/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat;

import com.tom.cpl.config.ModConfigFile;
import com.tom.vivecraftcompat.JadeOverlay;
import com.tom.vivecraftcompat.JourneyMapOverlay;
import com.tom.vivecraftcompat.VRMode;
import com.tom.vivecraftcompat.overlay.FloatingGui;
import com.tom.vivecraftcompat.overlay.OverlayConfig;
import com.tom.vivecraftcompat.overlay.OverlayManager;
import com.tom.vivecraftcompat.overlay.OverlaySettingsGui;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.vivecraft.client_vr.provider.ControllerType;

public class Client {
    public static ModConfigFile config;
    private static final Component CAM_BTN;
    private static final Component OVERLAY_BTN;

    public static void init() {
        NeoForge.EVENT_BUS.register(OverlayManager.class);
        NeoForge.EVENT_BUS.register(Client.class);
        config = new ModConfigFile(new File(FMLPaths.CONFIGDIR.get().toFile(), "vivecraftcompat.json"));
        OverlayConfig.loadOverlays();
    }

    @SubscribeEvent
    public static void initGui(ScreenEvent.Init.Post evt) {
        if (VRMode.isVR() && evt.getScreen() instanceof PauseScreen) {
            for (GuiEventListener l : evt.getListenersList()) {
                Button b;
                if (!(l instanceof Button) || !(b = (Button)l).getMessage().equals((Object)CAM_BTN)) continue;
                b = Button.builder((Component)OVERLAY_BTN, __ -> {
                    OverlayManager.Layer layer = new OverlayManager.Layer(i -> new FloatingGui(OverlaySettingsGui::new, (OverlayManager.Layer)i));
                    layer.spawnOverlay(ControllerType.RIGHT);
                    OverlayManager.addLayer(layer);
                    Minecraft.getInstance().setScreen(null);
                }).bounds(b.getX() + b.getWidth() + 5, b.getY(), 100, 20).build();
                evt.addListener((GuiEventListener)b);
                break;
            }
        }
    }

    public static void preInit(IEventBus bus) {
        bus.addListener(Client::registerOverlays);
    }

    public static void registerOverlays(RegisterGuiLayersEvent event) {
        if (ModList.get().isLoaded("jade")) {
            JadeOverlay.register(event);
        }
        if (ModList.get().isLoaded("journeymap")) {
            JourneyMapOverlay.register(event);
        }
    }

    static {
        CAM_BTN = Component.translatable((String)"vivecraft.gui.screenshot");
        OVERLAY_BTN = Component.translatable((String)"vivecraftcompat.gui.overlays");
    }
}

