/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.math.Box;
import com.tom.cpm.client.GuiImpl;
import com.tom.vivecraftcompat.overlay.OverlayManager;
import com.tom.vivecraftcompat.overlay.VRInteractableScreen;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.helpers.RenderHelper;

public class FloatingGui
extends GuiImpl
implements VRInteractableScreen {
    private OverlayManager.Layer layer;
    private boolean PointedR;
    public float cursorX2;
    public float cursorY2;
    private boolean lastPressedClick;
    private boolean lastPressedRClick;
    private boolean lastPressedShift;
    private boolean shift;
    private Box clickBounds;

    public FloatingGui(Function<IGui, Frame> creator, OverlayManager.Layer layer) {
        super(creator, null);
        this.layer = layer;
    }

    protected void init() {
        this.clickBounds = new Box(0, 0, this.width, this.height);
        super.init();
    }

    @Override
    public void processGui() {
        this.PointedR = false;
        if (!OverlayManager.dh.vrSettings.seated) {
            Vector3f pos = this.layer.getPos();
            Matrix4f rotation = this.layer.getRotation();
            Vector2f vec21 = GuiHandler.getTexCoordsForCursor((Vector3f)pos, (Matrix4f)rotation, (float)GuiHandler.GUI_SCALE, (VRData.VRDevicePose)OverlayManager.dh.vrPlayer.vrdata_room_pre.getController(0));
            float f = vec21.x;
            float f1 = vec21.y;
            if (!(f < 0.0f || f1 < 0.0f || f > 1.0f || f1 > 1.0f)) {
                float lx = this.cursorX2;
                float ly = this.cursorY2;
                if (this.cursorX2 == -1.0f) {
                    this.cursorX2 = (int)(f * (float)this.minecraft.getWindow().getScreenWidth());
                    this.cursorY2 = (int)(f1 * (float)this.minecraft.getWindow().getScreenHeight());
                    double cx = (double)(this.cursorX2 * (float)this.width / (float)this.minecraft.getWindow().getGuiScaledWidth()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                    double cy = (double)(this.cursorY2 * (float)this.height / (float)this.minecraft.getWindow().getGuiScaledHeight()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                    this.PointedR = this.clickBounds.isInBounds((int)cx, (int)cy);
                } else {
                    float f2 = (int)(f * (float)this.minecraft.getWindow().getScreenWidth());
                    float f3 = (int)(f1 * (float)this.minecraft.getWindow().getScreenHeight());
                    this.cursorX2 = this.cursorX2 * 0.7f + f2 * 0.3f;
                    this.cursorY2 = this.cursorY2 * 0.7f + f3 * 0.3f;
                    double cx = (double)(this.cursorX2 * (float)this.width / (float)this.minecraft.getWindow().getGuiScaledWidth()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                    double cy = (double)(this.cursorY2 * (float)this.height / (float)this.minecraft.getWindow().getGuiScaledHeight()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                    this.PointedR = this.clickBounds.isInBounds((int)cx, (int)cy);
                }
                if (this.PointedR && this.lastPressedClick && ((int)lx != (int)this.cursorX2 || (int)ly != (int)this.cursorY2)) {
                    double d2 = (double)Math.min(Math.max((int)this.cursorX2, 0), this.minecraft.getWindow().getScreenWidth()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                    double d3 = (double)Math.min(Math.max((int)this.cursorY2, 0), this.minecraft.getWindow().getScreenWidth()) * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
                    this.mouseDragged(d2, d3, 0, 0.0, 0.0);
                }
            } else {
                this.cursorX2 = -1.0f;
                this.cursorY2 = -1.0f;
                this.PointedR = false;
            }
        }
    }

    @Override
    public void processBindings() {
        if (this.PointedR && this.minecraft.options.keyShift.consumeClick()) {
            this.setShift(true);
            this.lastPressedShift = true;
        }
        if (!this.minecraft.options.keyShift.isDown() && this.lastPressedShift) {
            this.setShift(false);
            this.lastPressedShift = false;
        }
        double d2 = (double)(this.cursorX2 * (float)this.width / (float)this.minecraft.getWindow().getGuiScaledWidth()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        double d3 = (double)(this.cursorY2 * (float)this.height / (float)this.minecraft.getWindow().getGuiScaledHeight()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        if (this.PointedR && GuiHandler.KEY_SCROLL_UP.consumeClick()) {
            this.mouseScrolled(d2, d3, 0.0, 4.0);
        }
        if (this.PointedR && GuiHandler.KEY_SCROLL_DOWN.consumeClick()) {
            this.mouseScrolled(d2, d3, 0.0, -4.0);
        }
        if (this.PointedR && VivecraftVRMod.INSTANCE.keyMenuButton.consumeClick()) {
            this.keyPressed(256, 0, 0);
        }
    }

    private void setShift(boolean b) {
        this.shift = b;
    }

    public boolean isShiftDown() {
        return this.shift;
    }

    @Override
    public boolean isUsingController() {
        return this.PointedR;
    }

    public void render(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        double cx = (double)(this.cursorX2 * (float)this.width / (float)this.minecraft.getWindow().getGuiScaledWidth()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        double cy = (double)(this.cursorY2 * (float)this.height / (float)this.minecraft.getWindow().getGuiScaledHeight()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        int mx = (int)cx;
        int my = (int)cy;
        if (this.PointedR) {
            super.render(matrixStack, mx, my, partialTicks);
        } else {
            super.render(matrixStack, -1, -1, partialTicks);
        }
        if (this.PointedR) {
            RenderHelper.drawMouseMenuQuad((GuiGraphics)matrixStack, (int)mx, (int)my);
        }
    }

    public void renderBackground(GuiGraphics p_283688_, int p_296369_, int p_296477_, float p_294317_) {
    }

    public void onClose() {
        this.layer.remove();
    }

    public void displayError(String e) {
        this.minecraft.player.displayClientMessage((Component)Component.literal((String)e), false);
        this.onClose();
    }

    public void setClickBounds(Box clickBounds) {
        this.clickBounds = clickBounds;
    }

    @Override
    public boolean type(char ch) {
        return this.charTyped(ch, 0);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    @Override
    public boolean key(int key) {
        return this.keyPressed(key, 0, 0);
    }

    public void setupCut() {
        if (!this.noScissorTest) {
            int dw = GuiHandler.GUI_WIDTH;
            int dh = GuiHandler.GUI_HEIGHT;
            float multiplierX = (float)dw / (float)this.width;
            float multiplierY = (float)dh / (float)this.height;
            Box box = this.getContext().cutBox;
            RenderSystem.enableScissor((int)((int)((float)box.x * multiplierX)), (int)(dh - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
        }
    }

    @Override
    public boolean interact(int key, boolean press) {
        double d2 = (double)(this.cursorX2 * (float)this.width / (float)this.minecraft.getWindow().getGuiScaledWidth()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        double d3 = (double)(this.cursorY2 * (float)this.height / (float)this.minecraft.getWindow().getGuiScaledHeight()) * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        if (key == 0) {
            if (press && this.PointedR) {
                this.mouseClicked((int)d2, (int)d3, 0);
                this.lastPressedClick = true;
                return true;
            }
            if (this.lastPressedClick) {
                this.mouseReleased((int)d2, (int)d3, 0);
                this.lastPressedClick = false;
                return true;
            }
        } else if (key == 1) {
            if (press && this.PointedR) {
                this.layer.startMovingLayer(0);
                this.lastPressedRClick = true;
            } else if (this.lastPressedRClick) {
                this.lastPressedRClick = false;
                this.layer.stopMovingLayer();
            }
        }
        return false;
    }

    public void tick() {
        if (this.gui == null || this.minecraft == null) {
            return;
        }
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }
}

