/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.vivecraftcompat.Client;
import com.tom.vivecraftcompat.overlay.HudOverlayScreen;
import com.tom.vivecraftcompat.overlay.OverlayEnable;
import com.tom.vivecraftcompat.overlay.OverlayLock;
import com.tom.vivecraftcompat.overlay.OverlayManager;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class OverlayConfig {
    public static void loadOverlays() {
        ConfigEntry ovs = Client.config.getEntry("elements");
        ArrayList loadedLayers = new ArrayList();
        ovs.keySet().forEach(key -> {
            OverlayManager.Layer layer;
            ConfigEntry ce = ovs.getEntry(key);
            String name = ce.getString("name", "Overlay");
            ConfigEntry.ConfigEntryList oel = ce.getEntryList("elements");
            HudOverlayScreen ov = new HudOverlayScreen((String)key);
            ov.setName(name);
            ov.enable = OverlayEnable.byName(ce.getString("enable", ""));
            for (int i = 0; i < oel.size(); ++i) {
                String o = String.valueOf(oel.get(i));
                ResourceLocation id = ResourceLocation.tryParse((String)o);
                if (id == null) continue;
                ov.overlays.add(id);
            }
            ov.layer = layer = new OverlayManager.Layer(ov);
            layer.setScale(ce.getFloat("scale", 1.0f));
            layer.setLockDirect(OverlayLock.byName(ce.getString("lock", "")));
            ConfigEntry pos = ce.getEntry("pos");
            layer.setPos(new Vector3f(pos.getFloat("x", 0.0f), pos.getFloat("y", 0.0f), pos.getFloat("z", 0.0f)));
            ConfigEntry rot = ce.getEntry("rotation");
            if (rot.hasEntry("m00")) {
                Matrix4f mat = new Matrix4f();
                mat.m00(rot.getFloat("m00", 1.0f));
                mat.m01(rot.getFloat("m01", 0.0f));
                mat.m02(rot.getFloat("m02", 0.0f));
                mat.m10(rot.getFloat("m10", 0.0f));
                mat.m11(rot.getFloat("m11", 1.0f));
                mat.m12(rot.getFloat("m12", 0.0f));
                mat.m20(rot.getFloat("m20", 0.0f));
                mat.m21(rot.getFloat("m21", 0.0f));
                mat.m22(rot.getFloat("m22", 1.0f));
                Quaternionf quaternion = new Quaternionf();
                mat.getUnnormalizedRotation(quaternion);
                rot.setFloat("x", quaternion.x);
                rot.setFloat("y", quaternion.y);
                rot.setFloat("z", quaternion.z);
                rot.setFloat("w", quaternion.w);
            }
            float x = rot.getFloat("x", 0.0f);
            float y = rot.getFloat("y", 0.0f);
            float z = rot.getFloat("z", 0.0f);
            float w = rot.getFloat("w", 1.0f);
            Quaternionf quaternion = new Quaternionf(x, y, z, w);
            Matrix4f mat = new Matrix4f().rotate((Quaternionfc)quaternion);
            layer.setRotation(mat);
            loadedLayers.add(layer);
        });
        Minecraft.getInstance().execute(() -> loadedLayers.forEach(OverlayManager::addLayer));
    }

    public static void saveOverlays() {
        ModConfigFile.ConfigEntryTemp config = Client.config.createTemp();
        ConfigEntry ovs = config.getEntry("elements");
        ovs.clear();
        OverlayManager.forEachLayer(l -> {
            Screen patt0$temp = l.getScreen();
            if (patt0$temp instanceof HudOverlayScreen) {
                HudOverlayScreen h = (HudOverlayScreen)patt0$temp;
                ConfigEntry ce = ovs.getEntry(h.getId());
                ce.setString("name", h.getName());
                ce.setString("enable", h.enable.name().toLowerCase(Locale.ROOT));
                ConfigEntry.ConfigEntryList oel = ce.getEntryList("elements");
                h.overlays.forEach(e -> oel.add((Object)e.toString()));
                ce.setString("lock", l.getLock().name().toLowerCase(Locale.ROOT));
                ce.setFloat("scale", l.getScale());
                ConfigEntry pos = ce.getEntry("pos");
                Vector3f p = l.getPosRaw();
                pos.setFloat("x", p.x);
                pos.setFloat("y", p.y);
                pos.setFloat("z", p.z);
                ConfigEntry rot = ce.getEntry("rotation");
                Matrix4f rotationMatrix = l.getRotationRaw();
                Quaternionf quaternion = new Quaternionf();
                rotationMatrix.getUnnormalizedRotation(quaternion);
                rot.setFloat("x", quaternion.x);
                rot.setFloat("y", quaternion.y);
                rot.setFloat("z", quaternion.z);
                rot.setFloat("w", quaternion.w);
            }
        });
        config.saveConfig();
    }
}

