/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.api.documentation.annotations.Comp;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.MethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.Property;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderMethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderRegistrationMethod;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import groovyjarjarantlr4.v4.runtime.misc.Nullable;
import java.awt.Color;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.compat.groovyscript.GSPlugin;
import teamroots.embers.recipe.FluidReactionRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@RegistryDescription(linkGenerator="embers")
public class ReactionChamber
extends VirtualizedRegistry<FluidReactionRecipe> {
    @RecipeBuilderDescription(example={@Example(value=".fluidInput(fluid('lava') * 10).fluidOutput(fluid('steam') * 50)")})
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        RecipeRegistry.fluidReactionRecipes.removeAll(this.removeScripted());
        RecipeRegistry.fluidReactionRecipes.addAll(this.restoreFromBackup());
    }

    public void add(FluidReactionRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            RecipeRegistry.fluidReactionRecipes.add(recipe);
        }
    }

    public boolean remove(FluidReactionRecipe recipe) {
        if (RecipeRegistry.fluidReactionRecipes.removeIf(r -> r == recipe)) {
            this.addBackup(recipe);
            return true;
        }
        return false;
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="fluid('steam')")})
    public boolean removeByOutput(IIngredient output) {
        return RecipeRegistry.fluidReactionRecipes.removeIf(r -> {
            if (output.test(r.getOutput())) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.QUERY)
    public SimpleObjectStream<FluidReactionRecipe> streamRecipes() {
        return new SimpleObjectStream(RecipeRegistry.fluidReactionRecipes).setRemover(this::remove);
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, priority=2000, example={@Example(commented=true)})
    public void removeAll() {
        RecipeRegistry.fluidReactionRecipes.forEach(arg_0 -> ((ReactionChamber)this).addBackup(arg_0));
        RecipeRegistry.fluidReactionRecipes.clear();
    }

    @Property.Properties(value={@Property(property="fluidInput", valid={@Comp(value="1")}), @Property(property="fluidOutput", valid={@Comp(value="1")})})
    public static class RecipeBuilder
    extends AbstractRecipeBuilder<FluidReactionRecipe> {
        @Property(valid={@Comp(type=Comp.Type.GTE, value="0"), @Comp(type=Comp.Type.LTE, value="1")})
        private float red;
        @Property(valid={@Comp(type=Comp.Type.GTE, value="0"), @Comp(type=Comp.Type.LTE, value="1")})
        private float green;
        @Property(valid={@Comp(type=Comp.Type.GTE, value="0"), @Comp(type=Comp.Type.LTE, value="1")})
        private float blue;

        @RecipeBuilderMethodDescription(field={"red", "green", "blue"})
        public RecipeBuilder particleColor(float ... color) {
            if (color.length != 3) {
                GroovyLog.get().warn("Error setting color in Embers Reaction Chamber recipe. Color must contain 3 floats, yet it contained {}", new Object[]{color.length});
                return this;
            }
            this.red = color[0];
            this.green = color[1];
            this.blue = color[2];
            return this;
        }

        @RecipeBuilderMethodDescription(field={"red", "green", "blue"})
        public RecipeBuilder color(float ... color) {
            return this.particleColor(color);
        }

        @RecipeBuilderMethodDescription(field={"red", "green", "blue"})
        public RecipeBuilder particleColor(int hex) {
            Color color = new Color(hex);
            this.red = (float)color.getRed() / 255.0f;
            this.green = (float)color.getGreen() / 255.0f;
            this.blue = (float)color.getBlue() / 255.0f;
            return this;
        }

        @RecipeBuilderMethodDescription(field={"red", "green", "blue"})
        public RecipeBuilder color(int hex) {
            return this.particleColor(hex);
        }

        @RecipeBuilderMethodDescription(priority=100)
        public RecipeBuilder red(float red) {
            this.red = red;
            return this;
        }

        @RecipeBuilderMethodDescription(priority=100)
        public RecipeBuilder green(float green) {
            this.green = green;
            return this;
        }

        @RecipeBuilderMethodDescription(priority=100)
        public RecipeBuilder blue(float blue) {
            this.blue = blue;
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Embers Reaction Chamber recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg);
            this.validateFluids(msg, 1, 1, 1, 1);
            msg.add(this.red < 0.0f || this.red > 1.0f, "red must be a float between 0 and 1, yet it was {}", new Object[]{Float.valueOf(this.red)});
            msg.add(this.green < 0.0f || this.green > 1.0f, "green must be a float between 0 and 1, yet it was {}", new Object[]{Float.valueOf(this.green)});
            msg.add(this.blue < 0.0f || this.blue > 1.0f, "blue must be a float between 0 and 1, yet it was {}", new Object[]{Float.valueOf(this.blue)});
        }

        @RecipeBuilderRegistrationMethod
        @Nullable
        public FluidReactionRecipe register() {
            if (!this.validate()) {
                return null;
            }
            FluidReactionRecipe recipe = new FluidReactionRecipe((FluidStack)this.fluidInput.get(0), (FluidStack)this.fluidOutput.get(0), new Color(this.red, this.green, this.blue));
            GSPlugin.instance.reactionchamber.add(recipe);
            return recipe;
        }
    }
}

