/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.api.misc.ILiquidFuel;
import teamroots.embers.apiimpl.EmbersAPIImpl;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.compat.Util;
import teamroots.embers.compat.jei.category.AlchemyRecipeCategory;
import teamroots.embers.compat.jei.category.BoilerRecipeCategory;
import teamroots.embers.compat.jei.category.DawnstoneAnvilCategory;
import teamroots.embers.compat.jei.category.EngineRecipeCategory;
import teamroots.embers.compat.jei.category.GeologicSeparatorRecipeCategory;
import teamroots.embers.compat.jei.category.MelterRecipeCategory;
import teamroots.embers.compat.jei.category.MixingRecipeCategory;
import teamroots.embers.compat.jei.category.ReactionChamberCategory;
import teamroots.embers.compat.jei.category.StampRecipeCategory;
import teamroots.embers.compat.jei.wrapper.AlchemyRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.BoilerRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.DawnstoneAnvilWrapper;
import teamroots.embers.compat.jei.wrapper.EngineRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.MeltingRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.MixingRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.ReactionChamberRecipeWrapper;
import teamroots.embers.compat.jei.wrapper.StampingRecipeWrapper;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.FluidReactionRecipe;
import teamroots.embers.recipe.IWrappableRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.register.BlockRegister;

@JEIPlugin
public class EmbersJEIPlugin
implements IModPlugin {
    public static IJeiHelpers HELPER;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new StampRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GeologicSeparatorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MixingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlchemyRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DawnstoneAnvilCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BoilerRecipeCategory(guiHelper)});
        if (Util.isMysticalMechanicsIntegrationEnabled()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new EngineRecipeCategory(guiHelper)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new ReactionChamberCategory(guiHelper)});
    }

    public void register(IModRegistry reg) {
        HELPER = reg.getJeiHelpers();
        reg.handleRecipes(ItemStampingRecipe.class, StampingRecipeWrapper::new, "embers.stamp");
        reg.handleRecipes(ItemMeltingRecipe.class, MeltingRecipeWrapper::new, "embers.melter");
        reg.handleRecipes(ItemMeltingRecipe.class, MeltingRecipeWrapper::new, "embers.geologic_separator");
        reg.handleRecipes(FluidMixingRecipe.class, MixingRecipeWrapper::new, "embers.mixer");
        reg.handleRecipes(AlchemyRecipe.class, AlchemyRecipeWrapper::new, "embers.alchemy");
        reg.handleRecipes(DawnstoneAnvilRecipe.class, DawnstoneAnvilWrapper::new, "embers.dawnstone_anvil");
        reg.handleRecipes(LiquidFuelWithInput.class, recipe -> new BoilerRecipeWrapper(recipe.handler, recipe.input), "embers.boiler");
        reg.handleRecipes(FluidReactionRecipe.class, ReactionChamberRecipeWrapper::new, "embers.reaction_chamber");
        reg.addRecipes(EmbersJEIPlugin.expandRecipes(RecipeRegistry.stampingRecipes), "embers.stamp");
        reg.addRecipes(EmbersJEIPlugin.expandRecipes(RecipeRegistry.meltingRecipes), "embers.melter");
        reg.addRecipes((Collection)RecipeRegistry.meltingRecipes.stream().filter(recipe -> recipe.getBonusOutput() != null).collect(Collectors.toList()), "embers.geologic_separator");
        reg.addRecipes(EmbersJEIPlugin.expandRecipes(RecipeRegistry.mixingRecipes), "embers.mixer");
        reg.addRecipes(EmbersJEIPlugin.expandRecipes(RecipeRegistry.alchemyRecipes), "embers.alchemy");
        reg.addRecipes(EmbersJEIPlugin.expandRecipes(RecipeRegistry.dawnstoneAnvilRecipes), "embers.dawnstone_anvil");
        reg.addRecipes(EmbersJEIPlugin.expandLiquidFuels(EmbersAPIImpl.boilerLiquids), "embers.boiler");
        reg.addRecipes(EmbersJEIPlugin.expandRecipes(RecipeRegistry.fluidReactionRecipes), "embers.reaction_chamber");
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.STAMPER), new String[]{"embers.stamp"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.BLOCK_FURNACE), new String[]{"embers.melter"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.GEO_SEPARATOR), new String[]{"embers.geologic_separator"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.BLOCK_FURNACE), new String[]{"embers.geologic_separator"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.MIXER), new String[]{"embers.mixer"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.ALCHEMY_TABLET), new String[]{"embers.alchemy"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.DAWNSTONE_ANVIL), new String[]{"embers.dawnstone_anvil"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.MINI_BOILER), new String[]{"embers.boiler"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.REACTION_CHAMBER), new String[]{"embers.reaction_chamber"});
        reg.addRecipeCatalyst((Object)new ItemStack(BlockRegister.HEAT_COIL), new String[]{"minecraft.smelting"});
        if (Util.isMysticalMechanicsIntegrationEnabled()) {
            reg.handleRecipes(LiquidFuelWithInput.class, recipe -> new EngineRecipeWrapper(recipe.handler, recipe.input), "embers.steam_engine");
            reg.addRecipes(EmbersJEIPlugin.expandLiquidFuels(EmbersAPIImpl.steamEngineFuels), "embers.steam_engine");
            reg.addRecipeCatalyst((Object)new ItemStack(MysticalMechanicsIntegration.STEAM_ENGINE), new String[]{"embers.steam_engine"});
        }
    }

    public static List<List<ItemStack>> expandIngredients(Ingredient ingredient) {
        return EmbersJEIPlugin.expandIngredients(Lists.newArrayList((Object[])new Ingredient[]{ingredient}));
    }

    public static List<List<ItemStack>> expandIngredients(List<Ingredient> ingredients) {
        IStackHelper stackHelper = HELPER.getStackHelper();
        return stackHelper.expandRecipeItemStackInputs(ingredients);
    }

    public static List<Object> expandRecipes(List<?> recipes) {
        return recipes.stream().map(EmbersJEIPlugin::expandRecipe).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<?> expandRecipe(Object recipe) {
        if (recipe instanceof IWrappableRecipe) {
            return ((IWrappableRecipe)recipe).getWrappers();
        }
        return Lists.newArrayList((Object[])new Object[]{recipe});
    }

    private static List<LiquidFuelWithInput> expandLiquidFuels(List<ILiquidFuel> liquidFuels) {
        ArrayList<LiquidFuelWithInput> rList = new ArrayList<LiquidFuelWithInput>();
        for (ILiquidFuel handler : liquidFuels) {
            for (FluidStack input : handler.getMatchingFluids()) {
                rList.add(new LiquidFuelWithInput(input, handler));
            }
        }
        return rList;
    }

    static class LiquidFuelWithInput {
        FluidStack input;
        ILiquidFuel handler;

        public LiquidFuelWithInput(FluidStack input, ILiquidFuel handler) {
            this.input = input;
            this.handler = handler;
        }
    }
}

