/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaProjectile;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.util.Bezier;

public class Pillars
extends MagmaWormPhase {
    private static final double RANGE_ATTACK = 72.0;
    List<Entity> targets = new ArrayList<Entity>();

    public Pillars(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        return 0.5;
    }

    @Override
    public void onStart(EntityMagmaWorm worm) {
        List<Entity> possibleTargets = worm.getAttackTargets(new AxisAlignedBB(worm.field_70165_t - 72.0, worm.field_70163_u - 72.0, worm.field_70161_v - 72.0, worm.field_70165_t + 72.0, worm.field_70163_u + 72.0, worm.field_70161_v + 72.0));
        if (!possibleTargets.isEmpty()) {
            Entity target;
            int i;
            int tries = 3;
            ArrayList<Vec3d> points = new ArrayList<Vec3d>();
            points.add(new Vec3d(worm.field_70165_t, worm.field_70163_u, worm.field_70161_v));
            for (i = 0; i < 7; ++i) {
                target = possibleTargets.get(this.random.nextInt(possibleTargets.size()));
                this.targets.add(target);
            }
            for (i = 0; i < tries; ++i) {
                target = possibleTargets.get(this.random.nextInt(possibleTargets.size()));
                Vec3d lastPos = (Vec3d)points.get(points.size() - 1);
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double x = target.field_70165_t;
                double z = target.field_70161_v;
                double dx = Math.sin(angle) * 5.0;
                double dz = Math.cos(angle) * 5.0;
                double height = MagmaWormPhase.getHeight(worm.field_70170_p, lastPos.field_72450_a + dx, lastPos.field_72449_c + dz);
                points.add(new Vec3d(lastPos.field_72450_a + dx, height + 20.0 + this.random.nextDouble() * 10.0, lastPos.field_72449_c + dz));
                points.add(new Vec3d(x, height + 5.0 + this.random.nextDouble() * 10.0, z));
            }
            worm.setCurrentSpline(new Bezier(points), 10, 0.3);
        }
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        if (!this.targets.isEmpty() && worm.field_70173_aa % 10 == 5) {
            Entity target = this.targets.get(this.random.nextInt(this.targets.size()));
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double distance = this.random.nextDouble() * 12.0 + 0.0;
            double dx = Math.sin(angle) * distance;
            double dz = Math.cos(angle) * distance;
            double height = MagmaWormPhase.getHeight(worm.field_70170_p, target.field_70165_t + dx, target.field_70161_v + dz);
            Vec3d location = new Vec3d(target.field_70165_t + dx, height + 0.5, target.field_70161_v + dz);
            EntityMagmaProjectile projectile = new EntityMagmaProjectile(worm.field_70170_p, worm);
            projectile.func_70107_b(location.field_72450_a, location.field_72448_b, location.field_72449_c);
            projectile.makePillar(12.0f, (int)distance * 5);
            worm.field_70170_p.func_72838_d((Entity)projectile);
        }
    }

    @Override
    public void onUndig(EntityMagmaWorm worm) {
        Vec3d location = new Vec3d(worm.field_70165_t, worm.field_70163_u + 2.0, worm.field_70161_v);
        Pillars.splashMagma(worm, location, 12);
    }
}

