/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item.bauble;

import baubles.api.BaubleType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.item.IHeldEmberCell;
import teamroots.embers.api.item.IInventoryEmberCell;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.item.ItemEmberStorage;
import teamroots.embers.item.bauble.ItemBaubleBase;
import teamroots.embers.power.DefaultEmberItemCapability;

public class ItemEmberBulb
extends ItemBaubleBase
implements IInventoryEmberCell,
IHeldEmberCell {
    public static final double CAPACITY = 1000.0;

    public ItemEmberBulb() {
        super("ember_bulb", BaubleType.TRINKET, true);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public double getCapacity() {
        return 1000.0;
    }

    public ItemStack withFill(double ember) {
        ItemStack stack = new ItemStack((Item)this);
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            capability.setEmber(ember);
        }
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            subItems.add((Object)this.withFill(this.getCapacity()));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        IEmberCapability capability;
        return stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)).getEmber() < capability.getEmberCapacity();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            return (capability.getEmberCapacity() - capability.getEmber()) / capability.getEmberCapacity();
        }
        return 0.0;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            tooltip.add(ItemEmberStorage.formatEmber(capability.getEmber(), capability.getEmberCapacity()));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new EmberJarCapability(stack, this.getCapacity());
    }

    public static class EmberJarCapability
    extends DefaultEmberItemCapability
    implements IInventoryEmberCell,
    IHeldEmberCell {
        public EmberJarCapability(@Nonnull ItemStack stack, double capacity) {
            super(stack, capacity);
        }
    }
}

