/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityOpenTank;
import teamroots.embers.util.Misc;

public class TileEntityArchaicGeysir
extends TileEntityOpenTank
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    int ticksExisted = 0;
    long charge = 0L;

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(4.0, 256.0, 4.0);
    }

    public TileEntityArchaicGeysir() {
        this.tank = new FluidTank(Integer.MAX_VALUE){

            public void onContentsChanged() {
                TileEntityArchaicGeysir.this.func_70296_d();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (Misc.isGaseousFluid(resource)) {
                    TileEntityArchaicGeysir.this.setEscapedFluid(resource);
                    return resource.amount;
                }
                return 0;
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(false);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.field_145850_b.field_72995_K) {
            this.updateEscapeParticles();
        }
        this.lastEscapedTickServer = this.lastEscapedTickClient = this.field_145850_b.func_82737_E();
    }

    @Override
    protected void updateEscapeParticles() {
        Color fluidColor = new Color(99, 100, 135);
        Random random = new Random();
        float force = 0.5f;
        for (int i = 0; i < 15; ++i) {
            float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f * force;
            float yOffset = 1.1f + 0.4f * force;
            float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.6f * force;
            double angle = random.nextDouble() * 2.0 * Math.PI;
            float velocity = random.nextFloat() * 0.2f;
            float xVel = (float)Math.sin(angle) * (velocity *= force);
            float yVel = velocity * 5.0f;
            float zVel = (float)Math.cos(angle) * velocity;
            ParticleUtil.spawnParticleVapor(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + xOffset, (float)this.field_174879_c.func_177956_o() + yOffset, (float)this.field_174879_c.func_177952_p() + zOffset, xVel, yVel, zVel, (float)fluidColor.getRed() / 255.0f, (float)fluidColor.getGreen() / 255.0f, (float)fluidColor.getBlue() / 255.0f, (float)fluidColor.getAlpha() / 255.0f, 6.0f * force, 20.0f * force, 40);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }
}

