/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockEmberGauge;
import teamroots.embers.block.BlockItemGauge;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityCharger
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static double MAX_TRANSFER = ConfigMachine.CHARGER.maxTransfer;
    public static double MAX_CAPACITY = ConfigMachine.CHARGER.capacity;
    public IEmberCapability capability = new DefaultEmberCapability();
    int angle = 0;
    int turnRate = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            TileEntityCharger.this.func_70296_d();
        }
    };
    Random random = new Random();
    boolean isWorking;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityCharger() {
        this.capability.setEmberCapacity(MAX_CAPACITY);
        this.capability.setEmber(0.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (heldItem.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            player.func_184611_a(hand, this.inventory.insertItem(0, heldItem, false));
            this.func_70296_d();
            return true;
        }
        if (!stack.func_190926_b() && heldItem.func_190926_b()) {
            if (!this.func_145831_w().field_72995_K) {
                player.func_184611_a(hand, this.inventory.extractItem(0, stack.func_190916_E(), false));
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        boolean cancel;
        this.turnRate = 1;
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, EnumFacing.field_82609_l);
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        World world = this.func_145831_w();
        if (world.field_72995_K) {
            this.handleSound();
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        this.isWorking = false;
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && !(cancel = UpgradeUtil.doWork(this, upgrades))) {
            double emberAdded;
            IEmberCapability itemCapability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            double transferRate = UpgradeUtil.getTotalSpeedModifier(this, upgrades) * MAX_TRANSFER;
            if (transferRate > 0.0) {
                emberAdded = itemCapability.addAmount(Math.min(Math.abs(transferRate), this.capability.getEmber()), !world.field_72995_K);
                this.capability.removeAmount(emberAdded, !world.field_72995_K);
            } else {
                emberAdded = this.capability.addAmount(Math.min(Math.abs(transferRate), itemCapability.getEmber()), !world.field_72995_K);
                itemCapability.removeAmount(emberAdded, !world.field_72995_K);
            }
            if (emberAdded > 0.0) {
                this.isWorking = true;
            }
            this.func_70296_d();
            if (world.field_72995_K && this.isWorking && this.capability.getEmber() > 0.0) {
                int i = 0;
                while ((double)i < Math.ceil(this.capability.getEmber() / 500.0)) {
                    ParticleUtil.spawnParticleGlow(world, (float)this.func_174877_v().func_177958_n() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.func_174877_v().func_177956_o() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.func_174877_v().func_177952_p() + 0.25f + this.random.nextFloat() * 0.5f, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                    ++i;
                }
            }
        }
        this.angle += this.turnRate;
    }

    @Override
    public void playSound(int id) {
        if (id == 1) {
            Embers.proxy.playMachineSound(this, 1, SoundManager.COPPER_CHARGER_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        ItemStack stack;
        if ("ember".equals(dialType) && (stack = this.inventory.getStackInSlot(0)).hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability itemCapability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            information.add(BlockItemGauge.formatItemStack(stack));
            information.add(BlockEmberGauge.formatEmber(itemCapability.getEmber(), itemCapability.getEmberCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.ember_storage", (Object[])new Object[0])));
        }
    }
}

