/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.IFluidPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;

public class TileEntityFluidDropper
extends TileEntity
implements ITileEntityBase,
ITickable,
IFluidPipeConnectable,
IFluidPipePriority {
    Random random = new Random();
    FluidTank tank = new FluidTank(1000);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            EnumFacing facing = EnumFacing.DOWN;
            for (int i = 1; i <= 5; ++i) {
                IBlockState state;
                int pushed;
                FluidStack stack;
                IFluidHandler handler;
                BlockPos checkPos = this.field_174879_c.func_177967_a(facing, i);
                TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
                if (tile != null && (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) != null && (stack = this.tank.drain(this.tank.getCapacity(), false)) != null && (pushed = handler.fill(stack, false)) > 0) {
                    handler.fill(stack, true);
                    this.tank.drain(pushed, true);
                }
                if ((state = this.field_145850_b.func_180495_p(checkPos)).func_193401_d((IBlockAccess)this.field_145850_b, checkPos, EnumFacing.UP) == BlockFaceShape.SOLID || state.func_193401_d((IBlockAccess)this.field_145850_b, checkPos, EnumFacing.DOWN) == BlockFaceShape.SOLID) break;
            }
        }
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return EnumPipeConnection.PIPE;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return 50;
    }
}

