/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.itemmod.ModifierCore;

@Deprecated
public class ItemModUtil {
    public static final String HEAT_TAG = "embers:heat_tag";
    public static Map<Item, ModifierBase> modifierRegistry = new HashMap<Item, ModifierBase>();
    public static Map<String, ModifierBase> nameToModifier = new HashMap<String, ModifierBase>();
    public static ArrayList<ModifierBase> weaponModifiers = new ArrayList();
    public static ArrayList<ModifierBase> armorModifiers = new ArrayList();
    public static ArrayList<ModifierBase> otherModifiers = new ArrayList();

    @Deprecated
    public static void init() {
    }

    public static void registerModifier(Item item, ModifierBase modifier) {
        modifierRegistry.put(item, modifier);
        nameToModifier.put(modifier.name, modifier);
        if (!(modifier instanceof ModifierCore)) {
            switch (modifier.type) {
                case ALL: 
                case PROJECTILE: {
                    otherModifiers.add(modifier);
                    break;
                }
                case TOOL_OR_ARMOR: {
                    weaponModifiers.add(modifier);
                    armorModifiers.add(modifier);
                    break;
                }
                case TOOL: {
                    weaponModifiers.add(modifier);
                    break;
                }
                case ARMOR: 
                case HELMET: 
                case CHESTPLATE: 
                case LEGGINGS: 
                case BOOTS: {
                    armorModifiers.add(modifier);
                }
            }
        }
    }

    public static boolean canAnyModifierApply(ItemStack stack) {
        Item item = stack.func_77973_b();
        ArrayList<ModifierBase> testList = otherModifiers;
        if (item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemHoe) {
            testList = weaponModifiers;
        } else if (item instanceof ItemArmor) {
            testList = armorModifiers;
        }
        for (ModifierBase modifier : testList) {
            if (!modifier.canApplyTo(stack)) continue;
            return true;
        }
        return false;
    }

    public static void checkForTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(HEAT_TAG)) {
            stack.func_77978_p().func_74782_a(HEAT_TAG, (NBTBase)new NBTTagCompound());
            stack.func_77978_p().func_74775_l(HEAT_TAG).func_74768_a("heat_level", 0);
            stack.func_77978_p().func_74775_l(HEAT_TAG).func_74776_a("heat", 0.0f);
            stack.func_77978_p().func_74775_l(HEAT_TAG).func_74782_a("modifiers", (NBTBase)new NBTTagList());
        }
    }

    public static boolean isModValid(ItemStack stack, ItemStack mod) {
        ModifierBase b = modifierRegistry.get(mod.func_77973_b());
        return b.canApplyTo(stack);
    }

    public static boolean hasModifier(ItemStack stack, String name) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.func_77978_p().func_74775_l(HEAT_TAG).func_150295_c("modifiers", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                if (!compound.func_74764_b("name") || compound.func_74779_i("name").compareTo(name) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void addModifier(ItemStack stack, ItemStack mod) {
        ItemModUtil.checkForTag(stack);
        NBTTagList list = stack.func_77978_p().func_74775_l(HEAT_TAG).func_150295_c("modifiers", 10);
        ModifierBase modifier = modifierRegistry.get(mod.func_77973_b());
        if (ItemModUtil.getModifierLevel(stack, modifier.name) == 0) {
            NBTTagCompound modifierCompound = new NBTTagCompound();
            modifierCompound.func_74778_a("name", modifier.name);
            modifierCompound.func_74782_a("item", (NBTBase)mod.func_77955_b(new NBTTagCompound()));
            modifierCompound.func_74768_a("level", 1);
            list.func_74742_a((NBTBase)modifierCompound);
        } else {
            ItemModUtil.incModifierLevel(stack, modifier.name);
        }
        modifier.onApply(stack);
    }

    public static int incModifierLevel(ItemStack stack, String name) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.func_77978_p().func_74775_l(HEAT_TAG).func_150295_c("modifiers", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                if (!compound.func_74764_b("name") || compound.func_74779_i("name").compareTo(name) != 0) continue;
                compound.func_74768_a("level", compound.func_74762_e("level") + 1);
            }
        }
        return 0;
    }

    public static int getTotalModLevel(ItemStack stack) {
        int total = 0;
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.func_77978_p().func_74775_l(HEAT_TAG).func_150295_c("modifiers", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                ItemStack s = new ItemStack(compound.func_74775_l("item"));
                if (!ItemModUtil.modifierRegistry.get((Object)s.func_77973_b()).countTowardsTotalLevel) continue;
                total += compound.func_74762_e("level");
            }
        }
        return total;
    }

    public static void setModifierLevel(ItemStack stack, String name, int level) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.func_77978_p().func_74775_l(HEAT_TAG).func_150295_c("modifiers", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                if (!compound.func_74764_b("name") || compound.func_74779_i("name").compareTo(name) != 0) continue;
                compound.func_74768_a("level", level);
            }
        }
    }

    public static int getModifierLevel(ItemStack stack, String name) {
        if (ItemModUtil.hasHeat(stack)) {
            NBTTagList list = stack.func_77978_p().func_74775_l(HEAT_TAG).func_150295_c("modifiers", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                if (!compound.func_74764_b("name") || compound.func_74779_i("name").compareTo(name) != 0) continue;
                return compound.func_74762_e("level");
            }
        }
        return 0;
    }

    public static float getMaxHeat(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(HEAT_TAG)) {
            return 500.0f + 250.0f * stack.func_77978_p().func_74775_l(HEAT_TAG).func_74760_g("heat_level");
        }
        return 0.0f;
    }

    public static float getHeat(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(HEAT_TAG)) {
            return stack.func_77978_p().func_74775_l(HEAT_TAG).func_74760_g("heat");
        }
        return 0.0f;
    }

    public static int getLevel(ItemStack stack) {
        ItemModUtil.checkForTag(stack);
        return stack.func_77978_p().func_74775_l(HEAT_TAG).func_74762_e("heat_level");
    }

    public static void setLevel(ItemStack stack, int level) {
        ItemModUtil.checkForTag(stack);
        stack.func_77978_p().func_74775_l(HEAT_TAG).func_74768_a("heat_level", level);
    }

    public static void addHeat(ItemStack stack, float heat) {
        ItemModUtil.checkForTag(stack);
        stack.func_77978_p().func_74775_l(HEAT_TAG).func_74776_a("heat", Math.min(ItemModUtil.getMaxHeat(stack), ItemModUtil.getHeat(stack) + heat));
    }

    public static void setHeat(ItemStack stack, float heat) {
        ItemModUtil.checkForTag(stack);
        stack.func_77978_p().func_74775_l(HEAT_TAG).func_74776_a("heat", heat);
    }

    public static boolean hasHeat(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b(HEAT_TAG);
    }

    public static int getArmorMod(EntityLivingBase p, String name) {
        int l;
        int maxLevel = 0;
        if (ItemModUtil.hasHeat(p.func_184582_a(EntityEquipmentSlot.HEAD)) && (l = ItemModUtil.getModifierLevel(p.func_184582_a(EntityEquipmentSlot.HEAD), name)) > maxLevel) {
            maxLevel = l;
        }
        if (ItemModUtil.hasHeat(p.func_184582_a(EntityEquipmentSlot.CHEST)) && (l = ItemModUtil.getModifierLevel(p.func_184582_a(EntityEquipmentSlot.CHEST), name)) > maxLevel) {
            maxLevel = l;
        }
        if (ItemModUtil.hasHeat(p.func_184582_a(EntityEquipmentSlot.LEGS)) && (l = ItemModUtil.getModifierLevel(p.func_184582_a(EntityEquipmentSlot.LEGS), name)) > maxLevel) {
            maxLevel = l;
        }
        if (ItemModUtil.hasHeat(p.func_184582_a(EntityEquipmentSlot.FEET)) && (l = ItemModUtil.getModifierLevel(p.func_184582_a(EntityEquipmentSlot.FEET), name)) > maxLevel) {
            maxLevel = l;
        }
        return maxLevel;
    }
}

