/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockStone;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import teamroots.embers.config.ConfigWorld;
import teamroots.embers.entity.EntityAncientGolem;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.util.Misc;
import teamroots.embers.world.StructureBase;

public class WorldGenSmallRuin
extends StructureBase
implements IWorldGenerator {
    double l = Math.sin(1.0);

    public WorldGenSmallRuin() {
        super(7, 7);
        this.replaceWithAir = false;
        this.addBlockMapping(" ", Blocks.field_150350_a.func_176223_P());
        this.addBlockMapping(".", BlockRegister.STRUCTURE_MARKER.func_176203_a(1));
        this.addBlockMapping("A", BlockRegister.ARCHAIC_BRICKS.func_176223_P());
        this.addBlockMapping("T", BlockRegister.ASHEN_TILE.func_176223_P());
        this.addBlockMapping("L", BlockRegister.ARCHAIC_LIGHT.func_176223_P());
        this.addBlockMapping("G", BlockRegister.STRUCTURE_MARKER.func_176203_a(0));
        this.addBlockMapping("R", BlockRegister.ARCHAIC_EDGE.func_176223_P());
        this.addBlockMapping("B", BlockRegister.ASHEN_BRICK.func_176223_P());
        this.addLayer(new String[]{"       ", " BBTBB ", " BTTTB ", " TTTTT ", " BTTTB ", " BBTBB ", "       "});
        this.addLayer(new String[]{"  A.A  ", " AA.AA ", "AA...AA", "...G...", "AA...AA", " AA.AA ", "  A.A  "});
        this.addLayer(new String[]{"  A.A  ", " AA.AA ", "AA...AA", ".......", "AA...AA", " AA.AA ", "  A.A  "});
        this.addLayer(new String[]{"  AAA  ", " AAAAA ", "AA...AA", "AA...AA", "AA...AA", " AAAAA ", "  AAA  "});
        this.addLayer(new String[]{"       ", "  RRR  ", " R...R ", " R...R ", " R...R ", "  RRR  ", "       "});
        this.addLayer(new String[]{"       ", "       ", "  AAA  ", "  ALA  ", "  AAA  ", "       ", "       "});
    }

    @Override
    public void placeBlock(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == BlockRegister.STRUCTURE_MARKER) {
            if (state.func_177230_c().func_176201_c(state) == 0 && ConfigWorld.SMALL_RUIN.containGolem) {
                EntityAncientGolem golem = new EntityAncientGolem(world);
                golem.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), pos.func_177952_p());
                golem.func_180482_a(world.func_175649_E(pos), null);
                golem.func_110163_bv();
                world.func_72838_d((Entity)golem);
                world.func_175698_g(pos);
            } else if (state.func_177230_c().func_176201_c(state) == 1) {
                world.func_175698_g(pos);
            }
        } else {
            super.placeBlock(world, pos, state);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!WorldGenSmallRuin.isSmallRuinEnabled(world.field_73011_w.getDimension()) || world.field_72995_K) {
            return;
        }
        int xx = chunkX * 16 + 13 + Misc.random.nextInt(2);
        int zz = chunkZ * 16 + 13 + Misc.random.nextInt(2);
        if (ConfigWorld.SMALL_RUIN.chance == 0) {
            return;
        }
        if (world.func_189649_b(xx, zz) > 16) {
            int yy = 4 + Misc.random.nextInt(world.func_189649_b(xx, zz));
            if (random.nextInt(ConfigWorld.SMALL_RUIN.chance) == 0 && world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof BlockStone) {
                boolean canGenerate = false;
                BlockPos pos = new BlockPos(xx, yy, zz);
                if (world.func_175623_d(pos.func_177985_f(4)) || world.func_175623_d(pos.func_177985_f(3)) || world.func_175623_d(pos.func_177965_g(4)) || world.func_175623_d(pos.func_177965_g(3)) || world.func_175623_d(pos.func_177964_d(4)) || world.func_175623_d(pos.func_177964_d(3)) || world.func_175623_d(pos.func_177970_e(4)) || world.func_175623_d(pos.func_177970_e(3))) {
                    canGenerate = true;
                }
                if (canGenerate) {
                    this.generateIn(world, xx, yy - 2, zz, false);
                }
            }
        }
    }

    public static boolean isSmallRuinEnabled(int dimension) {
        return IntStream.of(ConfigWorld.SMALL_RUIN.blacklist).boxed().collect(Collectors.toList()).contains(dimension) == ConfigWorld.SMALL_RUIN.isWhiteList;
    }
}

