/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import teamroots.embers.Embers;
import teamroots.embers.block.BlockBaseGauge;
import teamroots.embers.tileentity.TileEntityItemGauge;

public class BlockItemGauge
extends BlockBaseGauge {
    public static final String DIAL_TYPE = "item";

    public BlockItemGauge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    @Override
    protected void getTEData(EnumFacing facing, ArrayList<String> text, TileEntity tileEntity) {
        IItemHandler handler;
        if (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (i >= 10) {
                    text.add("...");
                    return;
                }
                ItemStack stack = handler.getStackInSlot(i);
                String item = BlockItemGauge.formatItemStack(stack);
                text.add(I18n.func_135052_a((String)"embers.tooltip.itemdial.slot", (Object[])new Object[]{i, item}));
            }
        }
    }

    public static String formatItemStack(ItemStack stack) {
        DecimalFormat stackFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.item_amount");
        if (!stack.func_190926_b()) {
            return I18n.func_135052_a((String)"embers.tooltip.itemdial.item", (Object[])new Object[]{stackFormat.format(stack.func_190916_E()), stack.func_82833_r()});
        }
        return I18n.func_135052_a((String)"embers.tooltip.itemdial.noitem", (Object[])new Object[0]);
    }

    @Override
    public String getDialType() {
        return DIAL_TYPE;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityItemGauge();
    }
}

