/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.thaumcraft;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.config.ConfigCompat;
import teamroots.embers.util.EmberInventoryUtil;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ItemFocus;
import thecodex6824.thaumicaugmentation.common.item.ItemTieredCasterGauntlet;

public class TieredEmberCaster
extends ItemTieredCasterGauntlet {
    public boolean consumeVis(ItemStack is, EntityPlayer player, float amount, boolean crafting, boolean sim) {
        if (EmberInventoryUtil.getEmberTotal(player) < (double)amount) {
            return false;
        }
        if (!sim) {
            EmberInventoryUtil.removeEmber(player, amount);
        }
        return true;
    }

    public float getConsumptionModifier(ItemStack is, EntityPlayer player, boolean crafting) {
        double consumptionModifier = 1.0 - (double)CasterManager.getTotalVisDiscount((EntityPlayer)player);
        if (is.func_77973_b() == this) {
            consumptionModifier -= (double)this.getCasterVisDiscount(is);
        }
        return (float)(Math.max(consumptionModifier, 0.1) * ConfigCompat.THAUMCRAFT.emberMultiplier);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            double amt;
            String text = "";
            ItemStack focus = this.getFocusStack(stack);
            if (focus != null && !focus.func_190926_b() && (amt = (double)(((ItemFocus)focus.func_77973_b()).getVisCost(focus) * this.getConsumptionModifier(stack, null, false))) > 0.0) {
                text = String.format("%s%s %s", TextFormatting.RESET, VIS_FORMATTER.format(amt), I18n.func_135052_a((String)"item.Focus.cost_ember", (Object[])new Object[0]));
            }
            tooltip.add(String.format("%s%s%s %s", TextFormatting.ITALIC, TextFormatting.RED, I18n.func_135052_a((String)"thaumicperiphery.ember.cost", (Object[])new Object[0]), text));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

