/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaProjectile;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.util.Bezier;

public class Mortar
extends MagmaWormPhase {
    private static final double RANGE_ATTACK = 36.0;

    public Mortar(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        return 0.5;
    }

    @Override
    public void onStart(EntityMagmaWorm worm) {
        List<Entity> targets = worm.getAttackTargets(new AxisAlignedBB(worm.field_70165_t - 36.0, worm.field_70163_u - 36.0, worm.field_70161_v - 36.0, worm.field_70165_t + 36.0, worm.field_70163_u + 36.0, worm.field_70161_v + 36.0));
        if (!targets.isEmpty()) {
            int tries = this.random.nextInt(2) + 1;
            ArrayList<Vec3d> points = new ArrayList<Vec3d>();
            points.add(new Vec3d(worm.field_70165_t, worm.field_70163_u, worm.field_70161_v));
            for (int i = 0; i < tries; ++i) {
                Entity target = targets.get(this.random.nextInt(targets.size()));
                Vec3d lastPos = (Vec3d)points.get(points.size() - 1);
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double x = target.field_70165_t;
                double z = target.field_70161_v;
                double dx = Math.sin(angle) * 5.0;
                double dz = Math.cos(angle) * 5.0;
                double height = MagmaWormPhase.getHeight(worm.field_70170_p, lastPos.field_72450_a + dx, lastPos.field_72449_c + dz);
                points.add(new Vec3d(lastPos.field_72450_a + dx, height + 5.0 + this.random.nextDouble() * 15.0, lastPos.field_72449_c + dz));
                points.add(new Vec3d(x, height + 5.0 + this.random.nextDouble() * 15.0, z));
            }
            worm.setCurrentSpline(new Bezier(points), 10, 0.3);
        }
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        if (worm.field_70173_aa % 2 == 0) {
            for (int i = 0; i < 1; ++i) {
                int index = this.random.nextInt(Math.max(worm.getSegments() - 2, 1));
                Vec3d location = worm.pastPositions.get(index);
                double height = MagmaWormPhase.getHeight(worm.field_70170_p, location.field_72450_a, location.field_72449_c);
                if (!(location.field_72448_b - height > 4.0)) continue;
                Vec3d velocity = Vec3d.func_189986_a((float)(-90.0f + this.random.nextFloat() * 90.0f - 45.0f), (float)(this.random.nextFloat() * 360.0f)).func_186678_a((double)0.3f);
                EntityMagmaProjectile projectile = new EntityMagmaProjectile(worm.field_70170_p, worm);
                projectile.func_70107_b(location.field_72450_a, location.field_72448_b, location.field_72449_c);
                projectile.makeMortar(velocity);
                worm.field_70170_p.func_72838_d((Entity)projectile);
            }
        }
    }

    @Override
    public void onUndig(EntityMagmaWorm worm) {
        Vec3d location = new Vec3d(worm.field_70165_t, worm.field_70163_u + 2.0, worm.field_70161_v);
        Mortar.splashMagma(worm, location, 12);
    }
}

