/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.block.BlockCatalyticPlug;
import teamroots.embers.tileentity.TileEntityCatalyticPlug;

public class TileEntityCatalyticPlugRenderer
extends TileEntitySpecialRenderer<TileEntityCatalyticPlug> {
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityCatalyticPlug tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile != null && tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177230_c() instanceof BlockCatalyticPlug) {
            EnumFacing facing = (EnumFacing)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b((IProperty)BlockCatalyticPlug.FACING);
            FluidStack fluidStack = tile.getFluidStack();
            int capacity = tile.getCapacity();
            if (fluidStack != null) {
                Fluid fluid = fluidStack.getFluid();
                int amount = fluidStack.amount;
                int c = fluid.getColor(fluidStack);
                int blue = c & 0xFF;
                int green = c >> 8 & 0xFF;
                int red = c >> 16 & 0xFF;
                alpha = c >> 24 & 0xFF;
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill(fluidStack).toString());
                this.diffU = this.maxU - this.minU;
                this.diffV = this.maxV - this.minV;
                this.minU = (double)sprite.func_94209_e() + this.diffU * 0.25;
                this.maxU = (double)sprite.func_94212_f() - this.diffU * 0.25;
                this.minV = (double)sprite.func_94206_g() + this.diffV * 0.25;
                this.maxV = (double)sprite.func_94210_h() - this.diffV * 0.25;
                int i = this.func_178459_a().func_175626_b(tile.func_174877_v(), fluid.getLuminosity(fluidStack));
                int lightx = i >> 16 & 0xFFFF;
                int lighty = i & 0xFFFF;
                GlStateManager.func_179129_p();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                buffer.func_181662_b(x + 0.25, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.25).func_187315_a(this.minU, this.minV).func_187314_a(lightx, lighty).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
                buffer.func_181662_b(x + 0.75, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.25).func_187315_a(this.maxU, this.minV).func_187314_a(lightx, lighty).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
                buffer.func_181662_b(x + 0.75, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.75).func_187315_a(this.maxU, this.maxV).func_187314_a(lightx, lighty).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y + 0.125 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.75).func_187315_a(this.minU, this.maxV).func_187314_a(lightx, lighty).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179121_F();
        }
        super.func_192841_a((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
    }
}

