/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityCreativeEmberSource
extends TileEntity
implements ITileEntityBase,
ITickable {
    int ticksExisted = 0;
    BlockPos receivedFrom = null;
    public DefaultEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public boolean acceptsVolatile() {
            return true;
        }

        @Override
        public double addAmount(double value, boolean doAdd) {
            return value;
        }

        @Override
        public double removeAmount(double value, boolean doRemove) {
            return value;
        }
    };

    public TileEntityCreativeEmberSource() {
        this.capability.setEmberCapacity(ConfigMachine.CREATIVE_EMBER_SOURCE.capacity);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        if (this.capability.getEmber() < this.capability.getEmberCapacity()) {
            this.capability.setEmber(this.capability.getEmberCapacity());
            this.func_70296_d();
        }
    }
}

