/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Explosion;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.entity.EntityEmberProjectile;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IEmberPipeConnectable;
import teamroots.embers.tileentity.IEmberPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;
import teamroots.embers.util.PipePriorityMap;

public abstract class TileEntityEmberPipeBase
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPipeConnectable,
IEmberPipePriority {
    public static final int PRIORITY_BLOCK = 0;
    public static final int PRIORITY_PIPE = 0;
    Random random = new Random();
    boolean[] from = new boolean[EnumFacing.field_82609_l.length];
    boolean clogged = false;
    double packet;
    EnumFacing lastTransfer;
    boolean syncPacket;
    boolean syncCloggedFlag;
    boolean syncTransfer;
    int ticksExisted;
    int lastRobin;

    protected TileEntityEmberPipeBase() {
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.requiresSync()) {
            NBTTagCompound updateTag = this.getSyncTag();
            this.resetSync();
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    abstract int getCapacity();

    @Override
    public int getPriority(EnumFacing facing) {
        return 0;
    }

    public abstract EnumPipeConnection getInternalConnection(EnumFacing var1);

    abstract void setInternalConnection(EnumFacing var1, EnumPipeConnection var2);

    abstract boolean isConnected(EnumFacing var1);

    public void setFrom(EnumFacing facing, boolean flag) {
        this.from[facing.func_176745_a()] = flag;
    }

    public void resetFrom() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setFrom(facing, false);
        }
    }

    protected boolean isFrom(EnumFacing facing) {
        return this.from[facing.func_176745_a()];
    }

    protected boolean isAnySideUnclogged() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile;
            if (!this.isConnected(facing) || !((tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) instanceof TileEntityEmberPipeBase) || ((TileEntityEmberPipeBase)tile).clogged) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticksExisted;
            boolean packetMoved = false;
            if (this.packet > 0.0) {
                Object handler;
                PipePriorityMap<Integer, EnumFacing> possibleDirections = new PipePriorityMap<Integer, EnumFacing>();
                Object[] emberCapabilities = new Object[EnumFacing.field_82609_l.length];
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TileEntity tile;
                    if (!this.isConnected(facing) || this.isFrom(facing) || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null) continue;
                    handler = (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing.func_176734_d());
                    int priority = 0;
                    if (tile instanceof IEmberPipePriority) {
                        priority = ((IEmberPipePriority)tile).getPriority(facing.func_176734_d());
                    }
                    if (handler != null && handler.acceptsVolatile()) {
                        possibleDirections.put(priority, facing);
                        emberCapabilities[facing.func_176745_a()] = handler;
                        continue;
                    }
                    if (!(tile instanceof TileEntityEmberPipeBase)) continue;
                    possibleDirections.put(priority, facing);
                    emberCapabilities[facing.func_176745_a()] = tile;
                }
                Iterator iterator = possibleDirections.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ArrayList list = possibleDirections.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        EnumFacing facing = (EnumFacing)list.get((i + this.lastRobin) % list.size());
                        handler = emberCapabilities[facing.func_176745_a()];
                        packetMoved = this.pushStack(facing, handler);
                        if (this.lastTransfer != facing) {
                            this.syncTransfer = true;
                            this.lastTransfer = facing;
                            this.func_70296_d();
                        }
                        if (!packetMoved) continue;
                        ++this.lastRobin;
                        break;
                    }
                    if (!packetMoved) continue;
                    break;
                }
            }
            if (this.packet <= 0.0) {
                if (this.lastTransfer != null && !packetMoved) {
                    this.syncTransfer = true;
                    this.lastTransfer = null;
                    this.func_70296_d();
                }
                packetMoved = true;
                this.resetFrom();
            }
            if (this.clogged == packetMoved) {
                this.clogged = !packetMoved;
                this.syncCloggedFlag = true;
                this.func_70296_d();
            }
            if (this.clogged && this.packet > 1.0) {
                this.packet = Math.floor(this.packet * 0.7);
                this.syncPacket = true;
                this.func_70296_d();
            }
        } else if (this.lastTransfer != null && this.isConnected(this.lastTransfer)) {
            for (int i = 0; i < 3; ++i) {
                float dist = this.random.nextFloat() * 0.0f;
                int lifetime = 10;
                float vx = (float)this.lastTransfer.func_82601_c() / ((float)lifetime / (1.0f - dist));
                float vy = (float)this.lastTransfer.func_96559_d() / ((float)lifetime / (1.0f - dist));
                float vz = (float)this.lastTransfer.func_82599_e() / ((float)lifetime / (1.0f - dist));
                float x = (float)this.field_174879_c.func_177958_n() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_82601_c() * dist;
                float y = (float)this.field_174879_c.func_177956_o() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_96559_d() * dist;
                float z = (float)this.field_174879_c.func_177952_p() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_82599_e() * dist;
                float r = 255.0f;
                float g = 64.0f;
                float b = 16.0f;
                float size = this.random.nextFloat() * 2.0f + 2.0f;
                ParticleUtil.spawnParticlePipeFlow(this.field_145850_b, x, y, z, vx, vy, vz, r, g, b, 0.5f, size, lifetime);
            }
        }
    }

    private boolean pushStack(EnumFacing facing, Object handler) {
        IEmberCapability emberCapability;
        double added;
        if (handler instanceof IEmberCapability && (added = (emberCapability = (IEmberCapability)handler).addAmount(this.packet, true)) > 0.0) {
            this.packet = 0.0;
            return true;
        }
        if (handler instanceof TileEntityEmberPipeBase) {
            TileEntityEmberPipeBase pipe = (TileEntityEmberPipeBase)handler;
            if (pipe.packet <= 0.0) {
                pipe.packet = this.packet;
                pipe.setFrom(facing.func_176734_d(), true);
                this.packet = 0.0;
                return true;
            }
            boolean isColliding = true;
            int ends = 0;
            for (EnumFacing checkFacing : EnumFacing.field_82609_l) {
                if (!pipe.isConnected(checkFacing)) continue;
                ++ends;
                if (pipe.isFrom(checkFacing) || checkFacing == facing.func_176734_d()) continue;
                isColliding = false;
                break;
            }
            if (isColliding && ends > 1) {
                double posX = (double)this.field_174879_c.func_177958_n() + 0.5;
                double posY = (double)this.field_174879_c.func_177956_o() + 0.5;
                double posZ = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundManager.MINI_BOILER_RUPTURE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                Explosion explosion = this.field_145850_b.func_72885_a(null, posX, posY, posZ, 3.0f, true, false);
                this.field_145850_b.func_175698_g(this.field_174879_c);
                EffectDamage effect = new EffectDamage(4.0f, preset -> DamageSource.func_94539_a((Explosion)explosion), 10, 0.0);
                for (int i = 0; i < 12; ++i) {
                    EntityEmberProjectile proj = new EntityEmberProjectile(this.field_145850_b);
                    proj.initCustom(posX, posY, posZ, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, 10.0, null);
                    proj.setLifetime(20 + this.random.nextInt(40));
                    proj.setEffect(effect);
                    this.field_145850_b.func_72838_d((Entity)proj);
                }
            }
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    protected void resetSync() {
        this.syncPacket = false;
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
    }

    protected boolean requiresSync() {
        return this.syncPacket || this.syncCloggedFlag || this.syncTransfer;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    protected NBTTagCompound getSyncTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.syncPacket) {
            this.writePacket(compound);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(compound);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(compound);
        }
        return compound;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writePacket(tag);
        this.writeCloggedFlag(tag);
        this.writeLastTransfer(tag);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            tag.func_74757_a("from" + facing.func_176745_a(), this.from[facing.func_176745_a()]);
        }
        tag.func_74768_a("lastRobin", this.lastRobin);
        return tag;
    }

    private void writeCloggedFlag(NBTTagCompound tag) {
        tag.func_74757_a("clogged", this.clogged);
    }

    private void writeLastTransfer(NBTTagCompound tag) {
        tag.func_74768_a("lastTransfer", Misc.writeNullableFacing(this.lastTransfer));
    }

    private void writePacket(NBTTagCompound tag) {
        tag.func_74780_a("packet", this.packet);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("clogged")) {
            this.clogged = tag.func_74767_n("clogged");
        }
        if (tag.func_74764_b("packet")) {
            this.packet = tag.func_74769_h("packet");
        }
        if (tag.func_74764_b("lastTransfer")) {
            this.lastTransfer = Misc.readNullableFacing(tag.func_74762_e("lastTransfer"));
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!tag.func_74764_b("from" + facing.func_176745_a())) continue;
            this.from[facing.func_176745_a()] = tag.func_74767_n("from" + facing.func_176745_a());
        }
        if (tag.func_74764_b("lastRobin")) {
            this.lastRobin = tag.func_74762_e("lastRobin");
        }
    }
}

