/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Quaternion;
import teamroots.embers.util.Misc;

public class TurretHelper {
    Quaternion angleStart = new Quaternion(0.0f, 1.0f, 0.0f, 0.0f);
    Quaternion angleEnd = new Quaternion(0.0f, 1.0f, 0.0f, 0.0f);
    float slide;
    float slideLast;
    Vec3d front;
    Vec3d up;

    public TurretHelper(Vec3d front, Vec3d up) {
        this.front = front;
        this.up = up;
    }

    public Quaternion getCurrentAngle() {
        return Misc.slerp(this.angleStart, this.angleEnd, this.slide);
    }

    public Quaternion getCurrentAngle(float partialTicks) {
        return Misc.slerp(this.angleStart, this.angleEnd, (float)MathHelper.func_151238_b((double)this.slideLast, (double)this.slide, (double)partialTicks));
    }

    public static Vec3d getForward(Quaternion angle) {
        float x = 2.0f * (angle.x * angle.z + angle.w * angle.y);
        float y = 2.0f * (angle.y * angle.z - angle.w * angle.x);
        float z = 1.0f - 2.0f * (angle.x * angle.x + angle.y * angle.y);
        return new Vec3d((double)x, (double)y, (double)z).func_72432_b();
    }

    public static Vec3d getUp(Quaternion angle) {
        float x = 2.0f * (angle.x * angle.y - angle.w * angle.z);
        float y = 1.0f - 2.0f * (angle.x * angle.x + angle.z * angle.z);
        float z = 2.0f * (angle.y * angle.z + angle.w * angle.x);
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public static Vec3d getSide(Quaternion angle) {
        float x = 1.0f - 2.0f * (angle.y * angle.y + angle.z * angle.z);
        float y = 2.0f * (angle.x * angle.y + angle.w * angle.z);
        float z = 2.0f * (angle.x * angle.z - angle.w * angle.y);
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public void rotateTowards(Quaternion angle) {
        this.angleStart = this.getCurrentAngle();
        this.angleEnd = angle;
        this.slide = 0.0f;
    }

    public void rotateTowards(Vec3d forward) {
        Vec3d rotAxis = this.front.func_72431_c(forward = forward.func_72432_b()).func_72432_b();
        if (rotAxis.func_189985_c() == 0.0) {
            rotAxis = this.up;
        }
        double dot = this.front.func_72430_b(forward);
        double ang = Math.acos(dot);
        double s = Math.sin(ang / 2.0);
        Vec3d u = rotAxis.func_72432_b();
        this.rotateTowards(new Quaternion((float)(u.field_72450_a * s), (float)(u.field_72448_b * s), (float)(u.field_72449_c * s), (float)Math.cos(ang / 2.0)));
    }

    public void update(float speed) {
        this.slideLast = this.slide;
        this.slide = Math.min(this.slide + speed, 1.0f);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("angleStart", (NBTBase)TurretHelper.writeQuat(this.angleStart));
        compound.func_74782_a("angleEnd", (NBTBase)TurretHelper.writeQuat(this.angleEnd));
        compound.func_74776_a("slide", this.slide);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.angleStart = TurretHelper.readQuat(compound.func_74775_l("angleStart"));
        this.angleEnd = TurretHelper.readQuat(compound.func_74775_l("angleEnd"));
        this.slide = compound.func_74760_g("slide");
    }

    public static NBTTagCompound writeQuat(Quaternion quaternion) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74776_a("x", quaternion.x);
        compound.func_74776_a("y", quaternion.y);
        compound.func_74776_a("z", quaternion.z);
        compound.func_74776_a("w", quaternion.w);
        return compound;
    }

    public static Quaternion readQuat(NBTTagCompound compound) {
        return new Quaternion(compound.func_74760_g("x"), compound.func_74760_g("y"), compound.func_74760_g("z"), compound.func_74760_g("w"));
    }
}

