/*
 * Decompiled with CFR 0.152.
 */
package com.inferno.infernomod;

import com.inferno.infernomod.HealthRemover;
import com.inferno.infernomod.ModDataStorage;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.TradeWithVillagerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="infernomode")
public class EventSubscriber {
    private static int cooldown = 10;

    @NotNull
    private static MinecraftServer getServer(ServerStartedEvent event) {
        return event.getServer();
    }

    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Pre event) {
        ServerPlayer serverPlayer;
        FoodData foodData;
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && (foodData = (serverPlayer = (ServerPlayer)player).getFoodData()).getSaturationLevel() > 2.0f) {
            foodData.setSaturation(2.0f);
            foodData.setExhaustion(0.0f);
        }
    }

    @SubscribeEvent
    public static void onVillagerTrade(TradeWithVillagerEvent event) {
        AbstractVillager villager = event.getAbstractVillager();
        Level level = villager.level();
        if (!level.isClientSide) {
            EventSubscriber.summonLightning((ServerLevel)level, villager.getOnPos());
            villager.die(villager.damageSources().lightningBolt());
        }
    }

    public static void summonLightning(ServerLevel level, BlockPos pos) {
        LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
        if (lightning != null) {
            lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
            level.addFreshEntity((Entity)lightning);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DamageType type = event.getSource().type();
            if (player.getHealth() == 20.0f && event.getAmount() >= 20.0f && type != player.damageSources().fall().type()) {
                event.setAmount(19.0f);
            }
            if (type == player.damageSources().inFire().type() || type == player.damageSources().onFire().type() || type == player.damageSources().lava().type()) {
                player.setRemainingFireTicks(10000000);
            } else if (type == player.damageSources().starve().type()) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 240));
                player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 240));
                event.setAmount(3.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onTotemUse(LivingUseTotemEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!ModDataStorage.removeHearts(player.getUUID())) {
                event.setCanceled(true);
                return;
            }
            HealthRemover.updateHealth(player.getUUID());
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            UUID id = player.getUUID();
            HealthRemover.updateHealth(id);
            if (!ModDataStorage.loggedInBefore(id)) {
                ModDataStorage.setLoggedInBefore(id);
                player.addItem(new ItemStack((ItemLike)Items.COOKED_BEEF, 3));
            }
        }
    }

    @SubscribeEvent
    public static void onWitherDeath(LivingDeathEvent event) {
        LivingEntity victim = event.getEntity();
        if (!victim.level().isClientSide() && victim instanceof WitherBoss) {
            ModDataStorage.setWitherKilled(true);
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(FinalizeSpawnEvent event) {
        WaterAnimal animal;
        Mob mob = event.getEntity();
        Level level = mob.level();
        if (!level.isClientSide) {
            if (mob instanceof Monster) {
                Monster monster = (Monster)mob;
                Random rand = new Random();
                if (monster instanceof Zombie) {
                    Zombie zombie = (Zombie)monster;
                    zombie.setBaby(true);
                    int index = rand.nextInt(0, 3);
                    if (index == 0) {
                        zombie.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 10000000));
                    } else if (index == 1) {
                        zombie.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 10000000));
                    } else if (index == 2) {
                        zombie.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 10000000));
                    }
                } else if (monster instanceof Skeleton) {
                    Skeleton skeleton = (Skeleton)monster;
                    int index = rand.nextInt(0, 100);
                    if (index < 99) {
                        skeleton.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 10000000, 1));
                    } else {
                        skeleton.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 10000000));
                    }
                } else if (monster instanceof Spider) {
                    Spider spider = (Spider)monster;
                    int index = rand.nextInt(0, 2);
                    if (index == 0) {
                        spider.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 10000000));
                    } else if (index == 1) {
                        spider.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 10000000, 1));
                    }
                } else if (monster instanceof EnderMan) {
                    EnderMan enderman = (EnderMan)monster;
                    enderman.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 10000000));
                    enderman.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 10000000));
                    enderman.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 10000000));
                } else if (monster instanceof Piglin) {
                    Piglin piglin = (Piglin)monster;
                    if (rand.nextInt(0, 50) == 0) {
                        return;
                    }
                    event.setSpawnCancelled(true);
                    PiglinBrute brute = (PiglinBrute)EntityType.PIGLIN_BRUTE.create(level);
                    assert (brute != null);
                    brute.moveTo(piglin.position());
                    brute.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
                    level.addFreshEntity((Entity)brute);
                }
            }
        } else if (mob instanceof Animal) {
            Animal animal2 = (Animal)mob;
            if (mob instanceof Pig) {
                Pig monster = (Pig)mob;
            }
        } else if (mob instanceof WaterAnimal && (animal = (WaterAnimal)mob) instanceof Squid) {
            Squid squid = (Squid)animal;
            if (level.isRaining()) {
                event.setSpawnCancelled(true);
                Drowned drowned = (Drowned)EntityType.DROWNED.create(level);
                drowned.moveTo(squid.position());
                drowned.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
                level.addFreshEntity((Entity)drowned);
            }
        }
    }

    @SubscribeEvent
    public static void onTriedEyePlacing(PlayerInteractEvent.RightClickBlock event) {
        BlockState blockState;
        ItemStack item = event.getItemStack();
        Level level = event.getEntity().level();
        if (!level.isClientSide && (blockState = level.getBlockState(event.getPos())) != null && item.getItem() == Items.ENDER_EYE && blockState.getBlock() instanceof EndPortalFrameBlock && !ModDataStorage.getWitherKilled()) {
            event.setCanceled(true);
            event.getEntity().sendSystemMessage((Component)Component.literal((String)"The Wither awaits...").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFF0000))));
        }
    }

    private <T> T getGoal(Set<WrappedGoal> goals) {
        for (WrappedGoal goal : goals) {
            try {
                Goal t = goal.getGoal();
                return (T)t;
            }
            catch (ClassCastException e) {
            }
        }
        return null;
    }
}

