/*
 * Decompiled with CFR 0.152.
 */
package com.inferno.infernomod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@EventBusSubscriber(modid="infernomode")
public class ModDataStorage {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String PLAYER_DATA_FILE = "stats/inferno_player_statistics.json";
    private static final String WORLD_DATA_FILE = "stats/inferno_server_info.json";
    private static JsonObject playerDataMap = new JsonObject();
    private static JsonObject worldDataMap = new JsonObject();
    public static MinecraftServer server;

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        server = event.getServer();
        ModDataStorage.loadData(server);
    }

    public static void loadData(MinecraftServer server) {
        File worldFile;
        File playerFile = new File(server.getWorldPath(LevelResource.ROOT).toFile(), PLAYER_DATA_FILE);
        if (playerFile.exists()) {
            try (FileReader reader = new FileReader(playerFile);){
                playerDataMap = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                playerDataMap = new JsonObject();
            }
        } else {
            playerDataMap = new JsonObject();
        }
        if ((worldFile = new File(server.getWorldPath(LevelResource.ROOT).toFile(), WORLD_DATA_FILE)).exists()) {
            try (FileReader reader = new FileReader(worldFile);){
                worldDataMap = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                worldDataMap = new JsonObject();
            }
        } else {
            worldDataMap = new JsonObject();
        }
    }

    public static void saveData(MinecraftServer server) {
        File directory = new File(server.getWorldPath(LevelResource.ROOT).toFile(), "/stats/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File playerFile = new File(server.getWorldPath(LevelResource.ROOT).toFile(), PLAYER_DATA_FILE);
        try (FileWriter writer = new FileWriter(playerFile);){
            gson.toJson((JsonElement)playerDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File worldFile = new File(server.getWorldPath(LevelResource.ROOT).toFile(), WORLD_DATA_FILE);
        try (FileWriter writer = new FileWriter(worldFile);){
            gson.toJson((JsonElement)worldDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getHeartsReduced(UUID playerUUID) {
        JsonObject playerStats = playerDataMap.getAsJsonObject(playerUUID.toString());
        if (playerStats != null && playerStats.has("heartsReduced")) {
            return playerStats.get("heartsReduced").getAsInt();
        }
        return 0;
    }

    public static void setHeartsReduced(UUID playerUUID, int heartsReduced) {
        JsonObject playerStats = playerDataMap.getAsJsonObject(playerUUID.toString());
        if (playerStats == null) {
            playerStats = new JsonObject();
            playerDataMap.add(playerUUID.toString(), (JsonElement)playerStats);
        }
        playerStats.addProperty("heartsReduced", (Number)heartsReduced);
        ModDataStorage.saveData(server);
    }

    public static boolean removeHearts(UUID playerUUID) {
        int heartsReduced = ModDataStorage.getHeartsReduced(playerUUID);
        if (heartsReduced <= 20) {
            ModDataStorage.setHeartsReduced(playerUUID, ModDataStorage.getHeartsReduced(playerUUID) + 4);
            return true;
        }
        return false;
    }

    public static boolean getWitherKilled() {
        JsonObject worldStats = worldDataMap.getAsJsonObject("serverInfo");
        if (worldStats != null && worldStats.has("witherKilled")) {
            return worldStats.get("witherKilled").getAsBoolean();
        }
        return false;
    }

    public static void setWitherKilled(boolean bool) {
        JsonObject worldStats = worldDataMap.getAsJsonObject("serverInfo");
        if (worldStats == null) {
            worldStats = new JsonObject();
            worldDataMap.add("serverInfo", (JsonElement)worldStats);
        }
        worldStats.addProperty("witherKilled", Boolean.valueOf(bool));
        ModDataStorage.saveData(server);
    }

    public static boolean loggedInBefore(UUID playerID) {
        JsonObject playerStats = playerDataMap.getAsJsonObject(playerID.toString());
        if (playerStats != null && playerStats.has("loggedInBefore")) {
            return playerStats.get("loggedInBefore").getAsBoolean();
        }
        return false;
    }

    public static void setLoggedInBefore(UUID playerID) {
        JsonObject playerStats = playerDataMap.getAsJsonObject(playerID.toString());
        if (playerStats == null) {
            playerStats = new JsonObject();
            playerDataMap.add(playerID.toString(), (JsonElement)playerStats);
        }
        playerStats.addProperty("loggedInBefore", Boolean.valueOf(true));
        ModDataStorage.saveData(server);
    }
}

