/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.service.CraftingService;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.parts.AEBasePart;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class CraftingMonitorOpenProviderC2SPacket {
    private final AEKey what;

    public CraftingMonitorOpenProviderC2SPacket(AEKey what) {
        this.what = what;
    }

    public static void encode(CraftingMonitorOpenProviderC2SPacket msg, FriendlyByteBuf buf) {
        AEKey.writeKey((FriendlyByteBuf)buf, (AEKey)msg.what);
    }

    public static CraftingMonitorOpenProviderC2SPacket decode(FriendlyByteBuf buf) {
        AEKey key = AEKey.readKey((FriendlyByteBuf)buf);
        return new CraftingMonitorOpenProviderC2SPacket(key);
    }

    public static void handle(CraftingMonitorOpenProviderC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            IActionHost host;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            LogUtils.getLogger().info("EAP[S]: recv CraftingMonitorOpenProviderC2SPacket key={} from {}", (Object)msg.what, (Object)player.m_36316_().getName());
            AbstractContainerMenu patt0$temp = player.f_36096_;
            if (!(patt0$temp instanceof CraftingCPUMenu)) {
                LogUtils.getLogger().info("EAP[S]: not in CraftingCPUMenu, abort");
                return;
            }
            CraftingCPUMenu menu = (CraftingCPUMenu)patt0$temp;
            IGrid grid = null;
            Object target = menu.getTarget();
            if (target instanceof IActionHost && (host = (IActionHost)target).getActionableNode() != null) {
                grid = host.getActionableNode().getGrid();
            }
            if (grid == null) {
                LogUtils.getLogger().info("EAP[S]: grid is null, abort");
                return;
            }
            ICraftingService cs = grid.getCraftingService();
            if (!(cs instanceof CraftingService)) {
                LogUtils.getLogger().info("EAP[S]: craftingService is null/unsupported, abort");
                return;
            }
            CraftingService craftingService = (CraftingService)cs;
            Collection patterns = craftingService.getCraftingFor(msg.what);
            LogUtils.getLogger().info("EAP[S]: patterns found={} for key={}", (Object)patterns.size(), (Object)msg.what);
            if (patterns.isEmpty()) {
                return;
            }
            for (IPatternDetails pattern : patterns) {
                Iterable providers = craftingService.getProviders(pattern);
                for (ICraftingProvider provider : providers) {
                    BlockEntity pbe;
                    PatternProviderLogic ppl;
                    PatternProviderLogicHost host2;
                    if (!(provider instanceof PatternProviderLogic) || (host2 = ((PatternProviderLogicAccessor)(ppl = (PatternProviderLogic)provider)).eap$host()) == null || (pbe = host2.getBlockEntity()) == null) continue;
                    try {
                        if (host2 instanceof AEBasePart) {
                            AEBasePart part = (AEBasePart)host2;
                            host2.openMenu((Player)player, MenuLocators.forPart((AEBasePart)part));
                        } else {
                            host2.openMenu((Player)player, MenuLocators.forBlockEntity((BlockEntity)pbe));
                        }
                        context.setPacketHandled(true);
                        return;
                    }
                    catch (Throwable t) {
                        LogUtils.getLogger().error("EAP[S]: open provider UI failed at {}", (Object)pbe.m_58899_(), (Object)t);
                    }
                }
            }
            LogUtils.getLogger().info("EAP[S]: no provider UI opened for key={}", (Object)msg.what);
        });
        context.setPacketHandled(true);
    }
}

