/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import java.util.Arrays;

public class ArraySimplifier {
    public static long gcd(long a, long b) {
        while (b != 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public static long findGCD(long[] arr) {
        if (arr.length == 0) {
            return 0L;
        }
        long result = arr[0];
        for (int i = 1; i < arr.length && (result = ArraySimplifier.gcd(result, arr[i])) != 1L; ++i) {
        }
        return result;
    }

    public static long[] simplifyFraction(long[] arr) {
        if (arr.length == 0) {
            return new long[0];
        }
        long gcd = ArraySimplifier.findGCD(arr);
        if (gcd == 0L) {
            return Arrays.copyOf(arr, arr.length);
        }
        long[] simplified = new long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            simplified[i] = arr[i] / gcd;
        }
        return simplified;
    }

    public static long[] combine(long[] a, long[] b) {
        long[] out = new long[a.length + b.length];
        System.arraycopy(a, 0, out, 0, a.length);
        System.arraycopy(b, 0, out, a.length, b.length);
        return out;
    }

    public static long findGCDWithEarlyExit(long[] arr) {
        if (arr.length == 0) {
            return 0L;
        }
        long result = 0L;
        for (long v : arr) {
            if (v == 1L) {
                return 1L;
            }
            if (v == 0L || (result = result == 0L ? v : ArraySimplifier.gcd(result, v)) != 1L) continue;
            return 1L;
        }
        return result == 0L ? 0L : Math.abs(result);
    }

    public static long[] simplifyByGcd(long[] arr, long gcd) {
        if (gcd <= 1L) {
            return arr;
        }
        long[] out = new long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i] / gcd;
        }
        return out;
    }
}

