/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.patternprovider.PatternProviderLogic;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PatternProviderDataUtil {
    private static final boolean DEBUG = true;

    public static List<PatternData> getAllPatternData(PatternProviderLogic patternProvider) {
        ArrayList<PatternData> patternDataList = new ArrayList<PatternData>();
        if (patternProvider == null) {
            return patternDataList;
        }
        InternalInventory patternInventory = patternProvider.getPatternInv();
        if (patternInventory == null) {
            return patternDataList;
        }
        Level level = null;
        try {
            Method getBlockEntityMethod;
            Object blockEntity;
            Field hostField = patternProvider.getClass().getDeclaredField("host");
            hostField.setAccessible(true);
            Object host = hostField.get(patternProvider);
            if (host != null && (blockEntity = (getBlockEntityMethod = host.getClass().getMethod("getBlockEntity", new Class[0])).invoke(host, new Object[0])) != null) {
                Method getLevelMethod = blockEntity.getClass().getMethod("getLevel", new Class[0]);
                level = (Level)getLevelMethod.invoke(blockEntity, new Object[0]);
            }
        }
        catch (Exception e) {
            return patternDataList;
        }
        if (level == null) {
            return patternDataList;
        }
        for (int i = 0; i < patternInventory.size(); ++i) {
            IPatternDetails patternDetails;
            ItemStack patternStack = patternInventory.getStackInSlot(i);
            if (patternStack.m_41619_() || (patternDetails = PatternDetailsHelper.decodePattern((ItemStack)patternStack, level)) == null) continue;
            patternDataList.add(new PatternData(patternDetails, patternStack, i));
        }
        return patternDataList;
    }

    public static int getPatternCount(PatternProviderLogic patternProvider) {
        if (patternProvider == null) {
            return 0;
        }
        InternalInventory patternInventory = patternProvider.getPatternInv();
        if (patternInventory == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < patternInventory.size(); ++i) {
            if (patternInventory.getStackInSlot(i).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public static int getTotalSlots(PatternProviderLogic patternProvider) {
        if (patternProvider == null) {
            return 0;
        }
        InternalInventory patternInventory = patternProvider.getPatternInv();
        return patternInventory != null ? patternInventory.size() : 0;
    }

    public static int getAvailableSlots(PatternProviderLogic patternProvider) {
        return PatternProviderDataUtil.getTotalSlots(patternProvider) - PatternProviderDataUtil.getPatternCount(patternProvider);
    }

    public static boolean hasEnoughSlots(PatternProviderLogic patternProvider, int requiredSlots) {
        return PatternProviderDataUtil.getAvailableSlots(patternProvider) >= requiredSlots;
    }

    public static PatternData getPatternDataAtSlot(PatternProviderLogic patternProvider, int slotIndex) {
        if (patternProvider == null) {
            return null;
        }
        InternalInventory patternInventory = patternProvider.getPatternInv();
        if (patternInventory == null || slotIndex < 0 || slotIndex >= patternInventory.size()) {
            return null;
        }
        ItemStack patternStack = patternInventory.getStackInSlot(slotIndex);
        if (patternStack.m_41619_()) {
            return null;
        }
        Level level = null;
        try {
            Method getBlockEntityMethod;
            Object blockEntity;
            Field hostField = patternProvider.getClass().getDeclaredField("host");
            hostField.setAccessible(true);
            Object host = hostField.get(patternProvider);
            if (host != null && (blockEntity = (getBlockEntityMethod = host.getClass().getMethod("getBlockEntity", new Class[0])).invoke(host, new Object[0])) != null) {
                Method getLevelMethod = blockEntity.getClass().getMethod("getLevel", new Class[0]);
                level = (Level)getLevelMethod.invoke(blockEntity, new Object[0]);
            }
        }
        catch (Exception e) {
            return null;
        }
        if (level == null) {
            return null;
        }
        IPatternDetails patternDetails = PatternDetailsHelper.decodePattern((ItemStack)patternStack, level);
        if (patternDetails == null) {
            return null;
        }
        return new PatternData(patternDetails, patternStack, slotIndex);
    }

    public static boolean isEmpty(PatternProviderLogic patternProvider) {
        return PatternProviderDataUtil.getPatternCount(patternProvider) == 0;
    }

    public static boolean isFull(PatternProviderLogic patternProvider) {
        return PatternProviderDataUtil.getAvailableSlots(patternProvider) == 0;
    }

    public static int getPatternPriority(PatternProviderLogic patternProvider) {
        if (patternProvider == null) {
            return 0;
        }
        return patternProvider.getPatternPriority();
    }

    public static boolean isConnectedToNetwork(PatternProviderLogic patternProvider) {
        if (patternProvider == null) {
            return false;
        }
        return patternProvider.getGrid() != null;
    }

    public static boolean isActive(PatternProviderLogic patternProvider) {
        if (patternProvider == null) {
            return false;
        }
        IGrid grid = patternProvider.getGrid();
        if (grid == null) {
            return false;
        }
        try {
            Field mainNodeField = patternProvider.getClass().getDeclaredField("mainNode");
            mainNodeField.setAccessible(true);
            Object mainNode = mainNodeField.get(patternProvider);
            if (mainNode != null) {
                Method isActiveMethod = mainNode.getClass().getMethod("isActive", new Class[0]);
                return (Boolean)isActiveMethod.invoke(mainNode, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static String getDisplayName(PatternProviderLogic patternProvider) {
        if (patternProvider == null) {
            return "\u672a\u77e5\u6837\u677f\u4f9b\u5e94\u5668";
        }
        try {
            PatternContainerGroup group = patternProvider.getTerminalGroup();
            if (group != null && group.name() != null) {
                return group.name().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "\u6837\u677f\u4f9b\u5e94\u5668";
    }

    public static PatternScalingResult multiplyPatternAmounts(PatternProviderLogic patternProvider, double multiplier) {
        if (multiplier <= 0.0) {
            throw new IllegalArgumentException("\u500d\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        return PatternProviderDataUtil.scalePatternAmountsExtendedAEStyle(patternProvider, multiplier, true);
    }

    public static PatternScalingResult duplicatePatternAmountsExtendedAEStyle(PatternProviderLogic patternProvider, double multiplier) {
        if (multiplier <= 0.0) {
            throw new IllegalArgumentException("\u500d\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        return PatternProviderDataUtil.scalePatternAmountsExtendedAEStyle(patternProvider, multiplier, true);
    }

    public static PatternScalingResult dividePatternAmounts(PatternProviderLogic patternProvider, double divisor) {
        if (divisor <= 0.0) {
            throw new IllegalArgumentException("\u9664\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        return PatternProviderDataUtil.scalePatternAmountsExtendedAEStyle(patternProvider, 1.0 / divisor, false);
    }

    private static PatternScalingResult scalePatternAmountsExtendedAEStyle(PatternProviderLogic patternProvider, double scaleFactor, boolean isMultiply) {
        IPatternDetails originalPattern;
        ItemStack patternStack;
        int i;
        ArrayList<String> errors = new ArrayList<String>();
        int totalPatterns = 0;
        int scaledPatterns = 0;
        int failedPatterns = 0;
        if (patternProvider == null) {
            errors.add("\u6837\u677f\u4f9b\u5e94\u5668\u4e3anull");
            return new PatternScalingResult(0, 0, 0, errors);
        }
        InternalInventory patternInventory = patternProvider.getPatternInv();
        if (patternInventory == null) {
            errors.add("\u65e0\u6cd5\u8bbf\u95ee\u6837\u677f\u5e93\u5b58");
            return new PatternScalingResult(0, 0, 0, errors);
        }
        Level level = PatternProviderDataUtil.getPatternProviderLevel(patternProvider);
        if (level == null) {
            errors.add("\u65e0\u6cd5\u83b7\u53d6Level\u5bf9\u8c61\uff0c\u8bf7\u786e\u4fdd\u6837\u677f\u4f9b\u5e94\u5668\u5728\u6709\u6548\u7684\u4e16\u754c\u4e2d");
            return new PatternScalingResult(0, 0, 0, errors);
        }
        HashMap<Integer, ItemStack> originalPatterns = new HashMap<Integer, ItemStack>();
        for (i = 0; i < patternInventory.size(); ++i) {
            patternStack = patternInventory.getStackInSlot(i);
            if (patternStack.m_41619_()) continue;
            ++totalPatterns;
            originalPatterns.put(i, patternStack.m_41777_());
            try {
                originalPattern = PatternDetailsHelper.decodePattern((ItemStack)patternStack, (Level)level);
                if (originalPattern == null) {
                    errors.add("\u69fd\u4f4d " + i + ": \u65e0\u6cd5\u89e3\u7801\u6837\u677f");
                    ++failedPatterns;
                    continue;
                }
                if (!PatternProviderDataUtil.isPatternScalable(originalPattern) || !(scaleFactor < 1.0) || PatternProviderDataUtil.canScalePatternExtendedAEStyle(originalPattern, scaleFactor)) continue;
                errors.add("\u69fd\u4f4d " + i + ": \u6837\u677f\u6570\u91cf\u65e0\u6cd5\u6309\u6307\u5b9a\u6bd4\u4f8b\u7f29\u653e");
                ++failedPatterns;
                continue;
            }
            catch (Exception e) {
                errors.add("\u69fd\u4f4d " + i + ": \u6837\u677f\u9a8c\u8bc1\u5931\u8d25 - " + e.getMessage());
                ++failedPatterns;
            }
        }
        for (i = 0; i < patternInventory.size(); ++i) {
            patternStack = patternInventory.getStackInSlot(i);
            if (patternStack.m_41619_() || !originalPatterns.containsKey(i)) continue;
            try {
                originalPattern = PatternDetailsHelper.decodePattern((ItemStack)patternStack, (Level)level);
                if (originalPattern == null || !PatternProviderDataUtil.isPatternScalable(originalPattern)) continue;
                ItemStack scaledPatternStack = PatternProviderDataUtil.scalePatternExtendedAEStyle(originalPattern, scaleFactor, level);
                if (scaledPatternStack == null || scaledPatternStack.m_41619_()) {
                    errors.add("\u69fd\u4f4d " + i + ": \u6837\u677f\u7f29\u653e\u5931\u8d25");
                    ++failedPatterns;
                    continue;
                }
                PatternProviderDataUtil.setPatternWithPersistence(patternInventory, i, scaledPatternStack, patternProvider);
                ++scaledPatterns;
                continue;
            }
            catch (Exception e) {
                errors.add("\u69fd\u4f4d " + i + ": \u5904\u7406\u6837\u677f\u65f6\u53d1\u751f\u5f02\u5e38 - " + e.getMessage());
                ++failedPatterns;
                try {
                    PatternProviderDataUtil.setPatternWithPersistence(patternInventory, i, (ItemStack)originalPatterns.get(i), patternProvider);
                    continue;
                }
                catch (Exception restoreException) {
                    errors.add("\u69fd\u4f4d " + i + ": \u6062\u590d\u539f\u59cb\u6837\u677f\u5931\u8d25 - " + restoreException.getMessage());
                }
            }
        }
        try {
            patternProvider.updatePatterns();
        }
        catch (Exception e) {
            errors.add("\u66f4\u65b0\u6837\u677f\u5217\u8868\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
        return new PatternScalingResult(totalPatterns, scaledPatterns, failedPatterns, errors);
    }

    private static PatternScalingResult scalePatternAmounts(PatternProviderLogic patternProvider, double scaleFactor, boolean isMultiply) {
        ArrayList<String> errors = new ArrayList<String>();
        int totalPatterns = 0;
        int scaledPatterns = 0;
        int failedPatterns = 0;
        if (patternProvider == null) {
            errors.add("\u6837\u677f\u4f9b\u5e94\u5668\u4e3anull");
            return new PatternScalingResult(0, 0, 0, errors);
        }
        InternalInventory patternInventory = patternProvider.getPatternInv();
        if (patternInventory == null) {
            errors.add("\u65e0\u6cd5\u8bbf\u95ee\u6837\u677f\u5e93\u5b58");
            return new PatternScalingResult(0, 0, 0, errors);
        }
        Level level = null;
        try {
            Method getBlockEntityMethod;
            Object blockEntity;
            Field hostField = patternProvider.getClass().getDeclaredField("host");
            hostField.setAccessible(true);
            Object host = hostField.get(patternProvider);
            if (host != null && (blockEntity = (getBlockEntityMethod = host.getClass().getMethod("getBlockEntity", new Class[0])).invoke(host, new Object[0])) != null) {
                Method getLevelMethod = blockEntity.getClass().getMethod("getLevel", new Class[0]);
                level = (Level)getLevelMethod.invoke(blockEntity, new Object[0]);
            }
        }
        catch (Exception e) {
            errors.add("\u65e0\u6cd5\u83b7\u53d6Level\u5bf9\u8c61: " + e.getMessage());
            return new PatternScalingResult(0, 0, 0, errors);
        }
        if (level == null) {
            errors.add("Level\u5bf9\u8c61\u4e3anull");
            return new PatternScalingResult(0, 0, 0, errors);
        }
        for (int i = 0; i < patternInventory.size(); ++i) {
            ItemStack patternStack = patternInventory.getStackInSlot(i);
            if (patternStack.m_41619_()) continue;
            ++totalPatterns;
            try {
                double divisor;
                IPatternDetails originalPattern = PatternDetailsHelper.decodePattern((ItemStack)patternStack, level);
                if (originalPattern == null) {
                    errors.add("\u69fd\u4f4d " + i + ": \u65e0\u6cd5\u89e3\u7801\u6837\u677f");
                    ++failedPatterns;
                    continue;
                }
                boolean isCraftingPattern = originalPattern.getClass().getSimpleName().equals("AECraftingPattern");
                if (isCraftingPattern) continue;
                if (scaleFactor < 1.0 && !PatternProviderDataUtil.canDivideProcessingPattern(originalPattern, divisor = 1.0 / scaleFactor)) {
                    errors.add("\u69fd\u4f4d " + i + ": \u6837\u677f\u6570\u91cf\u4e3a1\u6216\u4e0d\u80fd\u88ab\u6574\u9664\uff0c\u8df3\u8fc7\u9664\u6cd5\u64cd\u4f5c");
                    ++failedPatterns;
                    continue;
                }
                ItemStack scaledPatternStack = PatternProviderDataUtil.scalePattern(originalPattern, scaleFactor, level);
                if (scaledPatternStack == null || scaledPatternStack.m_41619_()) {
                    errors.add("\u69fd\u4f4d " + i + ": \u6837\u677f\u7f29\u653e\u5931\u8d25");
                    ++failedPatterns;
                    continue;
                }
                PatternProviderDataUtil.setPatternWithPersistence(patternInventory, i, scaledPatternStack, patternProvider);
                ++scaledPatterns;
                continue;
            }
            catch (Exception e) {
                errors.add("\u69fd\u4f4d " + i + ": \u5904\u7406\u6837\u677f\u65f6\u53d1\u751f\u5f02\u5e38 - " + e.getMessage());
                ++failedPatterns;
            }
        }
        try {
            patternProvider.updatePatterns();
        }
        catch (Exception e) {
            errors.add("\u66f4\u65b0\u6837\u677f\u5217\u8868\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
        return new PatternScalingResult(totalPatterns, scaledPatterns, failedPatterns, errors);
    }

    private static ItemStack scalePattern(IPatternDetails originalPattern, double scaleFactor, Level level) {
        try {
            double divisor;
            String def = String.valueOf(originalPattern.getDefinition()).toLowerCase();
            boolean isCrafting = def.contains("crafting");
            if (isCrafting) {
                return null;
            }
            if (scaleFactor < 1.0 && !PatternProviderDataUtil.canDivideProcessingPattern(originalPattern, divisor = 1.0 / scaleFactor)) {
                return null;
            }
            return PatternProviderDataUtil.scaleProcessingPattern(originalPattern, scaleFactor);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean canDivideProcessingPattern(IPatternDetails originalPattern, double divisor) {
        try {
            IPatternDetails.IInput[] originalInputs = originalPattern.getInputs();
            GenericStack[] originalOutputs = originalPattern.getOutputs();
            for (IPatternDetails.IInput iInput : originalInputs) {
                GenericStack primaryInput;
                long currentAmount;
                GenericStack[] possibleInputs = iInput.getPossibleInputs();
                long multiplier = iInput.getMultiplier();
                if (possibleInputs.length <= 0 || possibleInputs[0] == null || (currentAmount = (primaryInput = possibleInputs[0]).amount() * multiplier) != 1L && ((double)currentAmount % divisor == 0.0 || !((double)currentAmount < divisor))) continue;
                return false;
            }
            for (IPatternDetails.IInput iInput : originalOutputs) {
                long currentAmount;
                if (iInput == null || iInput.what() == null || (currentAmount = iInput.amount()) != 1L && ((double)currentAmount % divisor == 0.0 || !((double)currentAmount < divisor))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void setPatternWithPersistence(InternalInventory patternInventory, int slot, ItemStack newPattern, PatternProviderLogic patternProvider) {
        try {
            block7: {
                patternInventory.setItemDirect(slot, newPattern);
                try {
                    Method getBlockEntityMethod;
                    Object blockEntity;
                    Field hostField = patternProvider.getClass().getDeclaredField("host");
                    hostField.setAccessible(true);
                    Object host = hostField.get(patternProvider);
                    if (host == null || (blockEntity = (getBlockEntityMethod = host.getClass().getMethod("getBlockEntity", new Class[0])).invoke(host, new Object[0])) == null) break block7;
                    Method setChangedMethod = blockEntity.getClass().getMethod("setChanged", new Class[0]);
                    setChangedMethod.invoke(blockEntity, new Object[0]);
                    try {
                        Method getBlockPosMethod;
                        Object blockPos;
                        Field levelField = blockEntity.getClass().getSuperclass().getDeclaredField("level");
                        levelField.setAccessible(true);
                        Level level = (Level)levelField.get(blockEntity);
                        if (level != null && !level.m_5776_() && (blockPos = (getBlockPosMethod = blockEntity.getClass().getMethod("getBlockPos", new Class[0])).invoke(blockEntity, new Object[0])) != null) {
                            Method getBlockStateMethod = blockEntity.getClass().getMethod("getBlockState", new Class[0]);
                            Object blockState = getBlockStateMethod.invoke(blockEntity, new Object[0]);
                            level.m_7260_((BlockPos)blockPos, (BlockState)blockState, (BlockState)blockState, 3);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception hostField) {
                    // empty catch block
                }
            }
            patternProvider.updatePatterns();
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bbe\u7f6e\u6837\u677f\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
        }
    }

    private static Level getPatternProviderLevel(PatternProviderLogic patternProvider) {
        try {
            Method getBlockEntityMethod;
            Object blockEntity;
            Field hostField = patternProvider.getClass().getDeclaredField("host");
            hostField.setAccessible(true);
            Object host = hostField.get(patternProvider);
            if (host != null && (blockEntity = (getBlockEntityMethod = host.getClass().getMethod("getBlockEntity", new Class[0])).invoke(host, new Object[0])) != null) {
                Method getLevelMethod = blockEntity.getClass().getMethod("getLevel", new Class[0]);
                return (Level)getLevelMethod.invoke(blockEntity, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isPatternScalable(IPatternDetails pattern) {
        if (pattern == null) {
            return false;
        }
        String def = String.valueOf(pattern.getDefinition()).toLowerCase();
        boolean isCrafting = def.contains("crafting");
        return !isCrafting && pattern.getOutputs().length > 0;
    }

    private static boolean canScalePatternExtendedAEStyle(IPatternDetails pattern, double scaleFactor) {
        if (!PatternProviderDataUtil.isPatternScalable(pattern)) {
            return false;
        }
        try {
            if (scaleFactor >= 1.0) {
                return true;
            }
            double divisor = 1.0 / scaleFactor;
            for (IPatternDetails.IInput iInput : pattern.getInputs()) {
                long currentAmount;
                GenericStack[] possibleInputs = iInput.getPossibleInputs();
                long multiplier = iInput.getMultiplier();
                if (possibleInputs.length <= 0 || possibleInputs[0] == null || !((double)(currentAmount = possibleInputs[0].amount() * multiplier) < divisor) && (double)currentAmount % divisor == 0.0) continue;
                return false;
            }
            for (IPatternDetails.IInput iInput : pattern.getOutputs()) {
                long currentAmount;
                if (iInput == null || iInput.what() == null || !((double)(currentAmount = iInput.amount()) < divisor) && (double)currentAmount % divisor == 0.0) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static ItemStack scalePatternExtendedAEStyle(IPatternDetails originalPattern, double scaleFactor, Level level) {
        if (!PatternProviderDataUtil.isPatternScalable(originalPattern)) {
            return null;
        }
        try {
            IPatternDetails.IInput[] originalInputs = originalPattern.getInputs();
            GenericStack[] originalOutputs = originalPattern.getOutputs();
            ArrayList<GenericStack> scaledInputs = new ArrayList<GenericStack>();
            for (IPatternDetails.IInput input : originalInputs) {
                long newAmount;
                GenericStack[] possibleInputs = input.getPossibleInputs();
                long multiplier = input.getMultiplier();
                if (possibleInputs.length <= 0 || possibleInputs[0] == null) continue;
                GenericStack primaryInput = possibleInputs[0];
                long originalAmount = primaryInput.amount() * multiplier;
                if (scaleFactor >= 1.0) {
                    newAmount = Math.max(1L, Math.round((double)originalAmount * scaleFactor));
                } else {
                    double divisor = 1.0 / scaleFactor;
                    if ((double)originalAmount % divisor == 0.0) {
                        newAmount = Math.max(1L, (long)((double)originalAmount / divisor));
                    } else {
                        return null;
                    }
                }
                scaledInputs.add(new GenericStack(primaryInput.what(), newAmount));
            }
            ArrayList<GenericStack> scaledOutputs = new ArrayList<GenericStack>();
            for (GenericStack output : originalOutputs) {
                long newAmount;
                if (output == null || output.what() == null) continue;
                long originalAmount = output.amount();
                if (scaleFactor >= 1.0) {
                    newAmount = Math.max(1L, Math.round((double)originalAmount * scaleFactor));
                } else {
                    double divisor = 1.0 / scaleFactor;
                    if ((double)originalAmount % divisor == 0.0) {
                        newAmount = Math.max(1L, (long)((double)originalAmount / divisor));
                    } else {
                        return null;
                    }
                }
                scaledOutputs.add(new GenericStack(output.what(), newAmount));
            }
            return PatternDetailsHelper.encodeProcessingPattern((GenericStack[])scaledInputs.toArray(new GenericStack[0]), (GenericStack[])scaledOutputs.toArray(new GenericStack[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ItemStack scaleProcessingPattern(IPatternDetails originalPattern, double scaleFactor) {
        try {
            IPatternDetails.IInput[] originalInputs = originalPattern.getInputs();
            GenericStack[] originalOutputs = originalPattern.getOutputs();
            ArrayList<GenericStack> scaledInputs = new ArrayList<GenericStack>();
            for (IPatternDetails.IInput input : originalInputs) {
                GenericStack[] possibleInputs = input.getPossibleInputs();
                long multiplier = input.getMultiplier();
                if (possibleInputs.length <= 0 || possibleInputs[0] == null) continue;
                GenericStack primaryInput = possibleInputs[0];
                long newAmount = Math.max(1L, Math.round((double)(primaryInput.amount() * multiplier) * scaleFactor));
                scaledInputs.add(new GenericStack(primaryInput.what(), newAmount));
            }
            ArrayList<GenericStack> scaledOutputs = new ArrayList<GenericStack>();
            for (GenericStack output : originalOutputs) {
                if (output == null || output.what() == null) continue;
                long newAmount = Math.max(1L, Math.round((double)output.amount() * scaleFactor));
                scaledOutputs.add(new GenericStack(output.what(), newAmount));
            }
            return PatternDetailsHelper.encodeProcessingPattern((GenericStack[])scaledInputs.toArray(new GenericStack[0]), (GenericStack[])scaledOutputs.toArray(new GenericStack[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<PatternScalingPreview> previewPatternScaling(PatternProviderLogic patternProvider, double scaleFactor) {
        ArrayList<PatternScalingPreview> previews = new ArrayList<PatternScalingPreview>();
        if (patternProvider == null || scaleFactor <= 0.0) {
            return previews;
        }
        List<PatternData> patterns = PatternProviderDataUtil.getAllPatternData(patternProvider);
        for (PatternData pattern : patterns) {
            boolean isCraftingPattern = pattern.getPatternDetails().getClass().getSimpleName().equals("AECraftingPattern");
            if (isCraftingPattern) continue;
            PatternScalingPreview preview = new PatternScalingPreview(pattern.getSlotIndex(), pattern.getPatternDetails(), scaleFactor);
            previews.add(preview);
        }
        return previews;
    }

    public static class PatternData {
        private final IPatternDetails patternDetails;
        private final ItemStack patternStack;
        private final int slotIndex;
        private final List<InputData> inputs;
        private final List<OutputData> outputs;

        public PatternData(IPatternDetails patternDetails, ItemStack patternStack, int slotIndex) {
            this.patternDetails = patternDetails;
            this.patternStack = patternStack;
            this.slotIndex = slotIndex;
            this.inputs = new ArrayList<InputData>();
            this.outputs = new ArrayList<OutputData>();
            this.parseInputs();
            this.parseOutputs();
        }

        private void parseInputs() {
            IPatternDetails.IInput[] patternInputs = this.patternDetails.getInputs();
            for (int i = 0; i < patternInputs.length; ++i) {
                IPatternDetails.IInput input = patternInputs[i];
                GenericStack[] possibleInputs = input.getPossibleInputs();
                long multiplier = input.getMultiplier();
                for (GenericStack possibleInput : possibleInputs) {
                    if (possibleInput == null || possibleInput.what() == null) continue;
                    this.inputs.add(new InputData(possibleInput.what(), possibleInput.amount() * multiplier, i));
                }
            }
        }

        private void parseOutputs() {
            GenericStack[] patternOutputs = this.patternDetails.getOutputs();
            for (int i = 0; i < patternOutputs.length; ++i) {
                GenericStack output = patternOutputs[i];
                if (output == null || output.what() == null) continue;
                this.outputs.add(new OutputData(output.what(), output.amount(), i));
            }
        }

        public IPatternDetails getPatternDetails() {
            return this.patternDetails;
        }

        public ItemStack getPatternStack() {
            return this.patternStack;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public List<InputData> getInputs() {
            return this.inputs;
        }

        public List<OutputData> getOutputs() {
            return this.outputs;
        }

        public String getPatternDefinition() {
            return this.patternDetails.getDefinition().toString();
        }

        public boolean isCraftingPattern() {
            String def = String.valueOf(this.patternDetails.getDefinition()).toLowerCase();
            return def.contains("crafting");
        }

        public boolean isProcessingPattern() {
            String def = String.valueOf(this.patternDetails.getDefinition()).toLowerCase();
            return def.contains("processing") || def.contains("stonecutting") || def.contains("smithing");
        }

        public boolean isStonecuttingPattern() {
            return this.patternDetails.getDefinition().toString().contains("stonecutting");
        }

        public boolean isSmithingPattern() {
            return this.patternDetails.getDefinition().toString().contains("smithing");
        }

        public long getPrimaryOutputAmount() {
            if (this.outputs.isEmpty()) {
                return 0L;
            }
            return this.outputs.get(0).getAmount();
        }

        public boolean hasSecondaryOutputs() {
            return this.outputs.size() > 1;
        }
    }

    public static class PatternScalingResult {
        private final int totalPatterns;
        private final int scaledPatterns;
        private final int failedPatterns;
        private final List<String> errors;

        public PatternScalingResult(int totalPatterns, int scaledPatterns, int failedPatterns, List<String> errors) {
            this.totalPatterns = totalPatterns;
            this.scaledPatterns = scaledPatterns;
            this.failedPatterns = failedPatterns;
            this.errors = new ArrayList<String>(errors);
        }

        public int getTotalPatterns() {
            return this.totalPatterns;
        }

        public int getScaledPatterns() {
            return this.scaledPatterns;
        }

        public int getFailedPatterns() {
            return this.failedPatterns;
        }

        public List<String> getErrors() {
            return new ArrayList<String>(this.errors);
        }

        public boolean isSuccessful() {
            return this.failedPatterns == 0;
        }

        public boolean hasPartialSuccess() {
            return this.scaledPatterns > 0 && this.failedPatterns > 0;
        }
    }

    public static class PatternScalingPreview {
        private final int slotIndex;
        private final IPatternDetails originalPattern;
        private final double scaleFactor;
        private final List<InputPreview> inputPreviews;
        private final List<OutputPreview> outputPreviews;

        public PatternScalingPreview(int slotIndex, IPatternDetails originalPattern, double scaleFactor) {
            this.slotIndex = slotIndex;
            this.originalPattern = originalPattern;
            this.scaleFactor = scaleFactor;
            this.inputPreviews = new ArrayList<InputPreview>();
            this.outputPreviews = new ArrayList<OutputPreview>();
            this.calculatePreviews();
        }

        private void calculatePreviews() {
            for (IPatternDetails.IInput iInput : this.originalPattern.getInputs()) {
                GenericStack[] possibleInputs = iInput.getPossibleInputs();
                long multiplier = iInput.getMultiplier();
                if (possibleInputs.length <= 0 || possibleInputs[0] == null) continue;
                GenericStack primaryInput = possibleInputs[0];
                long originalAmount = primaryInput.amount() * multiplier;
                long newAmount = Math.max(1L, Math.round((double)originalAmount * this.scaleFactor));
                this.inputPreviews.add(new InputPreview(primaryInput.what(), originalAmount, newAmount));
            }
            for (IPatternDetails.IInput iInput : this.originalPattern.getOutputs()) {
                if (iInput == null || iInput.what() == null) continue;
                long originalAmount = iInput.amount();
                long newAmount = Math.max(1L, Math.round((double)originalAmount * this.scaleFactor));
                this.outputPreviews.add(new OutputPreview(iInput.what(), originalAmount, newAmount));
            }
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public double getScaleFactor() {
            return this.scaleFactor;
        }

        public List<InputPreview> getInputPreviews() {
            return new ArrayList<InputPreview>(this.inputPreviews);
        }

        public List<OutputPreview> getOutputPreviews() {
            return new ArrayList<OutputPreview>(this.outputPreviews);
        }
    }

    public static class OutputPreview {
        private final AEKey key;
        private final long originalAmount;
        private final long newAmount;

        public OutputPreview(AEKey key, long originalAmount, long newAmount) {
            this.key = key;
            this.originalAmount = originalAmount;
            this.newAmount = newAmount;
        }

        public AEKey getKey() {
            return this.key;
        }

        public long getOriginalAmount() {
            return this.originalAmount;
        }

        public long getNewAmount() {
            return this.newAmount;
        }

        public String getDisplayName() {
            return this.key.getDisplayName().getString();
        }
    }

    public static class InputPreview {
        private final AEKey key;
        private final long originalAmount;
        private final long newAmount;

        public InputPreview(AEKey key, long originalAmount, long newAmount) {
            this.key = key;
            this.originalAmount = originalAmount;
            this.newAmount = newAmount;
        }

        public AEKey getKey() {
            return this.key;
        }

        public long getOriginalAmount() {
            return this.originalAmount;
        }

        public long getNewAmount() {
            return this.newAmount;
        }

        public String getDisplayName() {
            return this.key.getDisplayName().getString();
        }
    }

    public static class OutputData {
        private final AEKey key;
        private final long amount;
        private final int outputIndex;

        public OutputData(AEKey key, long amount, int outputIndex) {
            this.key = key;
            this.amount = amount;
            this.outputIndex = outputIndex;
        }

        public AEKey getKey() {
            return this.key;
        }

        public long getAmount() {
            return this.amount;
        }

        public int getOutputIndex() {
            return this.outputIndex;
        }

        public String getDisplayName() {
            return this.key.getDisplayName().getString();
        }
    }

    public static class InputData {
        private final AEKey key;
        private final long amount;
        private final int inputIndex;

        public InputData(AEKey key, long amount, int inputIndex) {
            this.key = key;
            this.amount = amount;
            this.inputIndex = inputIndex;
        }

        public AEKey getKey() {
            return this.key;
        }

        public long getAmount() {
            return this.amount;
        }

        public int getInputIndex() {
            return this.inputIndex;
        }

        public String getDisplayName() {
            return this.key.getDisplayName().getString();
        }
    }
}

