/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.menu;

import appeng.api.config.YesNo;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import com.extendedae_plus.ae.parts.EntitySpeedTickerPart;
import com.extendedae_plus.ae.screen.EntitySpeedTickerScreen;
import com.extendedae_plus.api.config.EAPSettings;
import com.extendedae_plus.config.ModConfigs;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.util.entitySpeed.ConfigParsingUtils;
import com.extendedae_plus.util.entitySpeed.PowerUtils;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntitySpeedTickerMenu
extends UpgradeableMenu<EntitySpeedTickerPart> {
    private final EntitySpeedTickerPart logic;
    @GuiSync(value=716)
    public int energyCardCount;
    @GuiSync(value=717)
    public int effectiveSpeed = 1;
    @GuiSync(value=718)
    public double multiplier = 1.0;
    @GuiSync(value=719)
    public boolean targetBlacklisted = false;
    @GuiSync(value=720)
    public YesNo networkEnergySufficient;
    @GuiSync(value=721)
    private YesNo accelerate;
    @GuiSync(value=722)
    private YesNo redstoneControl;

    public EntitySpeedTickerMenu(int id, Inventory ip, EntitySpeedTickerPart host) {
        super((MenuType)ModMenuTypes.ENTITY_TICKER_MENU.get(), id, ip, (IUpgradeableObject)host);
        this.logic = host;
    }

    public void onServerDataSync(ShortSet updatedFields) {
        super.onServerDataSync(updatedFields);
        this.updateTargetStatus();
        this.updateEffectiveSpeed();
        if (this.isClientSide()) {
            this.refreshClientGui();
        }
    }

    public void onSlotChange(Slot slot) {
        super.onSlotChange(slot);
        if (this.isClientSide()) {
            this.updateEffectiveSpeed();
            this.refreshClientGui();
        }
    }

    public void broadcastChanges() {
        if (this.isServerSide()) {
            this.accelerate = (YesNo)this.logic.getConfigManager().getSetting(EAPSettings.ACCELERATE);
            this.redstoneControl = (YesNo)this.logic.getConfigManager().getSetting(EAPSettings.REDSTONE_CONTROL);
            this.networkEnergySufficient = this.logic.isNetworkEnergySufficient() ? YesNo.YES : YesNo.NO;
            this.energyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
            this.updateTargetStatus();
            this.updateEffectiveSpeed();
        }
        super.broadcastChanges();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
    }

    public YesNo getAccelerate() {
        return this.accelerate;
    }

    public YesNo getRedstoneControl() {
        return this.redstoneControl;
    }

    private void updateTargetStatus() {
        BlockEntity target = this.getTargetBlockEntity();
        if (target == null) {
            this.multiplier = 1.0;
            this.targetBlacklisted = false;
            return;
        }
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)target.getBlockState().getBlock()).toString();
        this.multiplier = ConfigParsingUtils.getMultiplierForBlock(blockId, (List)ModConfigs.ENTITY_TICKER_MULTIPLIERS.get());
        this.targetBlacklisted = ConfigParsingUtils.isBlockBlacklisted(blockId, (List)ModConfigs.ENTITY_TICKER_BLACK_LIST.get());
    }

    private void updateEffectiveSpeed() {
        this.effectiveSpeed = this.targetBlacklisted ? 0 : (int)PowerUtils.computeProductWithCap(this.getUpgrades(), 8);
    }

    private void refreshClientGui() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof EntitySpeedTickerScreen) {
            EntitySpeedTickerScreen screen2 = (EntitySpeedTickerScreen)screen;
            screen2.refreshGui();
        }
    }

    private BlockEntity getTargetBlockEntity() {
        return this.getHost() != null ? ((EntitySpeedTickerPart)this.getHost()).getLevel().getBlockEntity(((EntitySpeedTickerPart)this.getHost()).getBlockEntity().getBlockPos().relative(((EntitySpeedTickerPart)this.getHost()).getSide())) : null;
    }
}

