/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.parts;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Setting;
import appeng.api.config.YesNo;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigManagerBuilder;
import appeng.core.definitions.AEItems;
import appeng.items.parts.PartModels;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.UpgradeablePart;
import com.extendedae_plus.ae.menu.EntitySpeedTickerMenu;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.ae.wireless.endpoint.GenericNodeEndpointImpl;
import com.extendedae_plus.api.bridge.InterfaceWirelessLinkBridge;
import com.extendedae_plus.api.config.EAPSettings;
import com.extendedae_plus.config.ModConfigs;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.items.materials.ChannelCardItem;
import com.extendedae_plus.util.ExtendedAELogger;
import com.extendedae_plus.util.entitySpeed.ConfigParsingUtils;
import com.extendedae_plus.util.entitySpeed.PowerUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitySpeedTickerPart
extends UpgradeablePart
implements IGridTickable,
MenuProvider,
IUpgradeableObject,
InterfaceWirelessLinkBridge {
    private static final ResourceLocation MODEL_BASE = ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"part/entity_speed_ticker_part");
    @PartModels
    private static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"part/entity_speed_ticker_off")});
    @PartModels
    private static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"part/entity_speed_ticker_on")});
    @PartModels
    private static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"part/entity_speed_ticker_has_channel")});
    public EntitySpeedTickerMenu menu;
    private YesNo networkEnergySufficient = YesNo.YES;
    private WirelessSlaveLink wirelessLink;
    private long lastChannel = -1L;
    private UUID lastOwner;
    private boolean clientWirelessConnected = false;
    private boolean hasInitializedWireless = false;
    private int delayedInitTicks = 0;

    public EntitySpeedTickerPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(1.0).addService(IGridTickable.class, (IGridNodeService)this);
    }

    protected void registerSettings(IConfigManagerBuilder builder) {
        super.registerSettings(builder);
        builder.registerSetting(EAPSettings.ACCELERATE, (Enum)YesNo.YES);
        builder.registerSetting(EAPSettings.REDSTONE_CONTROL, (Enum)YesNo.NO);
    }

    protected int getUpgradeSlots() {
        return 8;
    }

    protected boolean isSleeping() {
        if (this.getConfigManager().getSetting(EAPSettings.ACCELERATE) != YesNo.YES) {
            return true;
        }
        if (this.getConfigManager().getSetting(EAPSettings.REDSTONE_CONTROL) != YesNo.YES) {
            return false;
        }
        return !this.getHost().hasRedstone();
    }

    protected void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.getMainNode().ifPresent((grid, node) -> {
            if (this.isSleeping()) {
                grid.getTickManager().sleepDevice(node);
            } else {
                grid.getTickManager().wakeDevice(node);
            }
        });
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (this.getConfigManager().getSetting(EAPSettings.REDSTONE_CONTROL) == YesNo.YES) {
            this.getMainNode().ifPresent((grid, node) -> {
                if (this.getHost().hasRedstone()) {
                    grid.getTickManager().wakeDevice(node);
                } else {
                    grid.getTickManager().sleepDevice(node);
                }
            });
        }
    }

    public final boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!this.isClientSide()) {
            MenuOpener.open((MenuType)((MenuType)ModMenuTypes.ENTITY_TICKER_MENU.get()), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 14.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 14.0);
    }

    public void saveChanges() {
        this.getHost().markForSave();
    }

    private boolean isAccelerate() {
        return this.getConfigManager().getSetting(EAPSettings.ACCELERATE) == YesNo.YES;
    }

    public boolean isNetworkEnergySufficient() {
        return this.networkEnergySufficient == YesNo.YES;
    }

    private void setNetworkEnergySufficient(boolean sufficient) {
        this.networkEnergySufficient = sufficient ? YesNo.YES : YesNo.NO;
        this.saveChanges();
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 1, this.isSleeping());
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int ticksSinceLastCall) {
        if (!this.isClientSide()) {
            if (!this.hasInitializedWireless) {
                this.initializeWirelessLink();
            } else if (this.wirelessLink != null && this.lastChannel != 0L) {
                this.wirelessLink.updateStatus();
            }
        }
        if (!this.isAccelerate()) {
            return TickRateModulation.IDLE;
        }
        if (this.isSleeping()) {
            return TickRateModulation.SLEEP;
        }
        BlockEntity target = this.getLevel().getBlockEntity(this.getBlockEntity().getBlockPos().relative(this.getSide()));
        if (target == null || !this.isActive()) {
            return TickRateModulation.IDLE;
        }
        this.ticker(target);
        return TickRateModulation.IDLE;
    }

    private <T extends BlockEntity> void ticker(@NotNull T blockEntity) {
        if (!this.isValidForTicking()) {
            return;
        }
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)blockEntity.getBlockState().getBlock()).toString();
        if (ConfigParsingUtils.isBlockBlacklisted(blockId, (List)ModConfigs.ENTITY_TICKER_BLACK_LIST.get())) {
            return;
        }
        BlockEntityTicker<T> ticker = this.getTicker(blockEntity);
        if (ticker == null) {
            return;
        }
        int speed = this.calculateSpeed();
        if (speed <= 0) {
            return;
        }
        double requiredPower = this.calculateRequiredPower(speed, blockId);
        if (!this.extractPower(requiredPower)) {
            return;
        }
        this.performTicks(blockEntity, ticker, speed);
    }

    private boolean isValidForTicking() {
        return this.getGridNode() != null && this.getMainNode() != null && this.getMainNode().getGrid() != null;
    }

    private <T extends BlockEntity> BlockEntityTicker<T> getTicker(T blockEntity) {
        return this.getLevel().getBlockState(blockEntity.getBlockPos()).getTicker(this.getLevel(), blockEntity.getType());
    }

    private int calculateSpeed() {
        int entitySpeedCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
        if (entitySpeedCardCount <= 0) {
            return 0;
        }
        return (int)PowerUtils.computeProductWithCap(this.getUpgrades(), 8);
    }

    private double calculateRequiredPower(int speed, String blockId) {
        int energyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
        double multiplier = ConfigParsingUtils.getMultiplierForBlock(blockId, (List)ModConfigs.ENTITY_TICKER_MULTIPLIERS.get());
        return PowerUtils.computeFinalPowerForProduct(speed, energyCardCount) * multiplier;
    }

    private <T extends BlockEntity> void performTicks(T blockEntity, BlockEntityTicker<T> ticker, int speed) {
        for (int i = 0; i < speed - 1; ++i) {
            try {
                ticker.tick(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage() != null && e.getMessage().contains("LegacyRandomSource")) {
                    ExtendedAELogger.LOGGER.warn("\u68c0\u6d4b\u5230\u65b9\u5757\u5b9e\u4f53 {} \u5728\u4f4d\u7f6e {} \u7684\u968f\u673a\u6570\u8bbf\u95ee\u51b2\u7a81\uff0c\u5df2\u505c\u6b62\u672c\u6b21\u52a0\u901f\u4ee5\u907f\u514d\u5d29\u6e83\u3002\u5efa\u8bae\u5c06\u6b64\u65b9\u5757\u7c7b\u578b\u6dfb\u52a0\u5230\u914d\u7f6e\u9ed1\u540d\u5355\u4e2d\u3002", (Object)blockEntity.getType().toString(), (Object)blockEntity.getBlockPos());
                    break;
                }
                throw e;
            }
            catch (Exception e) {
                ExtendedAELogger.LOGGER.error("\u5728\u52a0\u901f\u65b9\u5757\u5b9e\u4f53 {} \u4f4d\u7f6e {} \u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{blockEntity.getType().toString(), blockEntity.getBlockPos(), e.getMessage(), e});
                break;
            }
        }
    }

    public boolean hasCustomName() {
        return super.hasCustomName();
    }

    @NotNull
    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new EntitySpeedTickerMenu(containerId, playerInventory, this);
    }

    public void upgradesChanged() {
        super.upgradesChanged();
        if (this.isClientSide()) {
            return;
        }
        this.hasInitializedWireless = false;
        this.lastChannel = -1L;
        this.lastOwner = null;
        this.initializeWirelessLink();
    }

    @Override
    public void eap$updateWirelessLink() {
        if (this.isClientSide()) {
            return;
        }
        if (this.wirelessLink != null) {
            this.wirelessLink.updateStatus();
        }
    }

    @Override
    public boolean eap$isWirelessConnected() {
        if (this.isClientSide()) {
            return this.clientWirelessConnected;
        }
        return this.wirelessLink != null && this.wirelessLink.isConnected();
    }

    @Override
    public void eap$setClientWirelessState(boolean connected) {
        this.clientWirelessConnected = connected;
    }

    @Override
    public boolean eap$hasTickInitialized() {
        return this.hasInitializedWireless;
    }

    @Override
    public void eap$setTickInitialized(boolean initialized) {
        this.hasInitializedWireless = initialized;
    }

    @Override
    public void eap$initializeChannelLink() {
        this.initializeWirelessLink();
    }

    @Override
    public void eap$handleDelayedInit() {
        if (this.isClientSide()) {
            return;
        }
        if (!this.hasInitializedWireless) {
            this.initializeWirelessLink();
            return;
        }
        if (this.delayedInitTicks > 0) {
            --this.delayedInitTicks;
            if (this.delayedInitTicks == 0 && this.wirelessLink != null && !this.wirelessLink.isConnected()) {
                this.hasInitializedWireless = false;
                this.initializeWirelessLink();
            }
        }
    }

    @Override
    public boolean eap$shouldKeepTicking() {
        if (this.isClientSide()) {
            return false;
        }
        if (!this.hasInitializedWireless) {
            return true;
        }
        if (this.lastChannel == 0L) {
            return false;
        }
        return this.wirelessLink == null || !this.wirelessLink.isConnected();
    }

    private boolean extractPower(double requiredPower) {
        if (requiredPower <= 0.0) {
            return true;
        }
        try {
            IManagedGridNode node = this.getMainNode();
            if (node == null || node.getGrid() == null) {
                this.setNetworkEnergySufficient(false);
                return false;
            }
            IEnergyService energyService = node.getGrid().getEnergyService();
            double simulated = energyService.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (simulated + 1.0E-6 < requiredPower) {
                this.setNetworkEnergySufficient(false);
                return false;
            }
            energyService.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.setNetworkEnergySufficient(true);
            return true;
        }
        catch (Throwable throwable) {
            this.setNetworkEnergySufficient(false);
            return false;
        }
    }

    private void initializeWirelessLink() {
        boolean sameOwner;
        if (this.isClientSide()) {
            return;
        }
        IManagedGridNode node = this.getMainNode();
        if (node == null || node.getNode() == null) {
            this.hasInitializedWireless = false;
            return;
        }
        long channel = 0L;
        UUID owner = null;
        boolean found = false;
        for (ItemStack stack : this.getUpgrades()) {
            if (stack.isEmpty() || stack.getItem() != ModItems.CHANNEL_CARD.get()) continue;
            channel = ChannelCardItem.getChannel(stack);
            owner = ChannelCardItem.getOwnerUUID(stack);
            if (owner == null) {
                owner = this.getFallbackOwner();
            }
            found = true;
            break;
        }
        if (!found) {
            this.disconnectWirelessLink();
            this.lastChannel = 0L;
            this.lastOwner = null;
            this.hasInitializedWireless = true;
            this.delayedInitTicks = 0;
            try {
                this.getHost().markForUpdate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        boolean bl = sameOwner = this.lastOwner == null && owner == null || this.lastOwner != null && this.lastOwner.equals(owner);
        if (this.wirelessLink != null && this.lastChannel == channel && sameOwner) {
            if (this.wirelessLink.isConnected()) {
                this.hasInitializedWireless = true;
            } else {
                this.delayedInitTicks = Math.max(this.delayedInitTicks, 5);
            }
            return;
        }
        if (this.wirelessLink == null) {
            GenericNodeEndpointImpl endpoint = new GenericNodeEndpointImpl(() -> this.getHost().getBlockEntity(), () -> this.getMainNode().getNode());
            this.wirelessLink = new WirelessSlaveLink(endpoint);
        }
        this.wirelessLink.setPlacerId(owner);
        this.wirelessLink.setFrequency(channel);
        this.wirelessLink.updateStatus();
        this.lastChannel = channel;
        this.lastOwner = owner;
        this.hasInitializedWireless = this.wirelessLink.isConnected();
        this.delayedInitTicks = !this.hasInitializedWireless ? 5 : 0;
        try {
            this.getHost().markForUpdate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void disconnectWirelessLink() {
        if (this.wirelessLink != null) {
            this.wirelessLink.setPlacerId(null);
            this.wirelessLink.setFrequency(0L);
            this.wirelessLink.updateStatus();
        }
    }

    private UUID getFallbackOwner() {
        if (this.getMainNode() != null && this.getMainNode().getNode() != null) {
            return this.getMainNode().getNode().getOwningPlayerProfileId();
        }
        return null;
    }
}

