/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.screen;

import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.CommonButtons;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.util.Platform;
import com.extendedae_plus.ae.menu.EntitySpeedTickerMenu;
import com.extendedae_plus.api.config.EAPSettings;
import com.extendedae_plus.client.gui.widgets.EAPServerSettingToggleButton;
import com.extendedae_plus.client.gui.widgets.EAPSettingToggleButton;
import com.extendedae_plus.util.entitySpeed.PowerUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class EntitySpeedTickerScreen
extends UpgradeableScreen<EntitySpeedTickerMenu> {
    private final EAPSettingToggleButton<YesNo> accelerateButton;
    private final EAPSettingToggleButton<YesNo> redstoneControlButton;
    private final TextUpdater textUpdater = new TextUpdater();

    public EntitySpeedTickerScreen(EntitySpeedTickerMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)CommonButtons.togglePowerUnit());
        this.accelerateButton = new EAPServerSettingToggleButton<YesNo>(EAPSettings.ACCELERATE, YesNo.YES);
        this.addToLeftToolbar((Button)this.accelerateButton);
        this.redstoneControlButton = new EAPServerSettingToggleButton<YesNo>(EAPSettings.REDSTONE_CONTROL, YesNo.NO);
        this.addToLeftToolbar((Button)this.redstoneControlButton);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (((EntitySpeedTickerMenu)this.menu).targetBlacklisted) {
            this.accelerateButton.active = false;
            this.accelerateButton.set(YesNo.UNDECIDED);
        } else {
            this.accelerateButton.set(((EntitySpeedTickerMenu)this.menu).getAccelerate());
        }
        this.redstoneControlButton.set(((EntitySpeedTickerMenu)this.menu).getRedstoneControl());
        this.textUpdater.update();
    }

    public void refreshGui() {
        this.textUpdater.update();
    }

    private class TextUpdater {
        private TextUpdater() {
        }

        void update() {
            if (((EntitySpeedTickerMenu)((EntitySpeedTickerScreen)EntitySpeedTickerScreen.this).menu).targetBlacklisted) {
                this.updateBlacklist();
            } else {
                this.updateNormal();
            }
        }

        private void updateBlacklist() {
            this.set("enable", this.translatable("enable", new Object[0]));
            this.set("speed", this.translatable("speed", 0));
            this.set("energy", this.translatable("energy", Platform.formatPower((double)0.0, (boolean)false)));
            this.set("power_ratio", this.translatable("power_ratio", PowerUtils.formatPercentage(0.0)));
            this.set("multiplier", this.translatable("multiplier", "0.00x"));
        }

        private void updateNormal() {
            int energyCardCount = ((EntitySpeedTickerMenu)((EntitySpeedTickerScreen)EntitySpeedTickerScreen.this).menu).energyCardCount;
            double multiplier = ((EntitySpeedTickerMenu)((EntitySpeedTickerScreen)EntitySpeedTickerScreen.this).menu).multiplier;
            int effectiveSpeed = ((EntitySpeedTickerMenu)((EntitySpeedTickerScreen)EntitySpeedTickerScreen.this).menu).effectiveSpeed;
            double finalPower = PowerUtils.computeFinalPowerForProduct(effectiveSpeed, energyCardCount);
            double powerRatio = PowerUtils.getRemainingRatio(energyCardCount);
            this.set("enable", ((EntitySpeedTickerMenu)((EntitySpeedTickerScreen)EntitySpeedTickerScreen.this).menu).networkEnergySufficient == YesNo.YES ? null : this.translatable("warning_network_energy_insufficient", new Object[0]));
            this.set("speed", this.translatable("speed", effectiveSpeed));
            this.set("energy", this.translatable("energy", Platform.formatPower((double)finalPower, (boolean)false)));
            this.set("power_ratio", this.translatable("power_ratio", PowerUtils.formatPercentage(powerRatio)));
            this.set("multiplier", this.translatable("multiplier", String.format("%.2fx", multiplier)));
        }

        private Component translatable(String key, Object ... args) {
            return Component.translatable((String)("screen.extendedae_plus.entity_speed_ticker." + key), (Object[])args);
        }

        private void set(String id, Component c) {
            EntitySpeedTickerScreen.this.setTextContent(id, c);
        }
    }
}

