/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.api.config;

import appeng.api.config.Setting;
import appeng.api.config.YesNo;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public final class EAPSettings {
    private static final Map<String, Setting<?>> SETTINGS = new HashMap();
    public static final Setting<YesNo> ACCELERATE = EAPSettings.register((String)"accelerate", (Enum)YesNo.NO, (Enum[])new YesNo[]{YesNo.YES});
    public static final Setting<YesNo> REDSTONE_CONTROL = EAPSettings.register((String)"redstoneControl", (Enum)YesNo.NO, (Enum[])new YesNo[]{YesNo.YES});

    private EAPSettings() {
    }

    private static synchronized <T extends Enum<T>> Setting<T> register(String name, Class<T> enumClass) {
        Preconditions.checkState((!SETTINGS.containsKey(name) ? 1 : 0) != 0);
        Setting setting = new Setting(name, enumClass);
        SETTINGS.put(name, setting);
        return setting;
    }

    @SafeVarargs
    private static synchronized <T extends Enum<T>> Setting<T> register(String name, T firstOption, T ... moreOptions) {
        Preconditions.checkState((!SETTINGS.containsKey(name) ? 1 : 0) != 0);
        Setting setting = new Setting(name, firstOption.getDeclaringClass(), EnumSet.of(firstOption, moreOptions));
        SETTINGS.put(name, setting);
        return setting;
    }

    public static Setting<?> getOrThrow(String name) {
        Setting<?> setting = SETTINGS.get(name);
        if (setting == null) {
            throw new IllegalArgumentException("Unknown setting '" + name + "'");
        }
        return setting;
    }
}

