/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.api.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.core.AELog;
import com.extendedae_plus.items.InfinityBigIntegerCellItem;
import com.extendedae_plus.util.storage.InfinityDataStorage;
import com.extendedae_plus.util.storage.InfinityStorageManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.Nullable;

public class InfinityBigIntegerCellInventory
implements StorageCell {
    private final InfinityBigIntegerCellItem cell;
    private final ItemStack self;
    @Nullable
    private final InfinityStorageManager storageManager;
    private final ISaveProvider container;
    private Object2ObjectMap<AEKey, BigInteger> AEKey2AmountsMap;
    private int totalAEKeyType;
    private BigInteger totalAEKey2Amounts = BigInteger.ZERO;
    private boolean isPersisted = true;

    private InfinityBigIntegerCellInventory(InfinityBigIntegerCellItem cell, ItemStack stack, ISaveProvider saveProvider, @Nullable InfinityStorageManager storageManager) {
        this.cell = cell;
        this.self = stack;
        this.container = saveProvider;
        this.AEKey2AmountsMap = null;
        this.storageManager = storageManager;
        this.initData();
    }

    public static String formatBigInteger(BigInteger number) {
        int idx;
        DecimalFormat df = new DecimalFormat("#.##");
        BigDecimal bd = new BigDecimal(number);
        BigDecimal thousand = new BigDecimal(1000);
        String[] units = new String[]{"", "K", "M", "G", "T", "P", "E", "Z", "Y"};
        for (idx = 0; bd.compareTo(thousand) >= 0 && idx < units.length - 1; ++idx) {
            bd = bd.divide(thousand, 2, RoundingMode.HALF_UP);
        }
        if (idx == 0) {
            return bd.setScale(0, RoundingMode.DOWN).toPlainString();
        }
        return df.format(bd.doubleValue()) + units[idx];
    }

    static InfinityBigIntegerCellInventory createInventory(ItemStack stack, ISaveProvider saveProvider, @Nullable InfinityStorageManager storageManager) {
        Objects.requireNonNull(stack, "Cannot create cell inventory for null itemstack");
        Item item = stack.getItem();
        if (!(item instanceof InfinityBigIntegerCellItem)) {
            return null;
        }
        InfinityBigIntegerCellItem cell = (InfinityBigIntegerCellItem)item;
        return new InfinityBigIntegerCellInventory(cell, stack, saveProvider, storageManager);
    }

    private InfinityDataStorage getCellStorage() {
        if (this.getUUID() != null && this.storageManager != null) {
            return this.storageManager.getOrCreateCell(this.getUUID());
        }
        return InfinityDataStorage.EMPTY;
    }

    private void initData() {
        if (this.hasUUID()) {
            this.totalAEKeyType = this.getCellStorage().amounts.size();
            this.totalAEKey2Amounts = this.getCellStorage().itemCount.equals(BigInteger.ZERO) ? BigInteger.ZERO : this.getCellStorage().itemCount;
        } else {
            this.totalAEKeyType = 0;
            this.totalAEKey2Amounts = BigInteger.ZERO;
            this.getCellStoredMap();
        }
    }

    public CellState getStatus() {
        if (this.getTotalAEKey2Amounts().equals(BigInteger.ZERO)) {
            return CellState.EMPTY;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return 512.0;
    }

    public void persist() {
        if (this.isPersisted || this.storageManager == null) {
            return;
        }
        if (this.totalAEKey2Amounts.equals(BigInteger.ZERO)) {
            if (this.hasUUID()) {
                this.storageManager.removeCell(this.getUUID());
                CustomData data = (CustomData)this.self.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                CompoundTag tag = data.copyTag();
                tag.remove("infinity_cell_uuid");
                tag.remove("infinity_item_total");
                tag.remove("infinity_item_types");
                tag.remove("infinity_cell_item_count");
                this.self.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                this.initData();
            }
            return;
        }
        ListTag keys = new ListTag();
        ListTag amounts = new ListTag();
        BigInteger itemCount = BigInteger.ZERO;
        for (Object2ObjectMap.Entry entry : this.AEKey2AmountsMap.object2ObjectEntrySet()) {
            BigInteger amount = (BigInteger)entry.getValue();
            if (amount.compareTo(BigInteger.ZERO) <= 0) continue;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric(this.storageManager.getRegistries()));
            CompoundTag amountTag = new CompoundTag();
            amountTag.putByteArray("value", amount.toByteArray());
            amounts.add((Object)amountTag);
            itemCount = itemCount.add(amount);
        }
        if (keys.isEmpty()) {
            this.storageManager.updateCell(this.getUUID(), new InfinityDataStorage());
        } else {
            this.storageManager.modifyDisk(this.getUUID(), keys, amounts, itemCount);
        }
        this.totalAEKeyType = this.AEKey2AmountsMap.size();
        this.totalAEKey2Amounts = itemCount;
        CompoundTag tag = ((CustomData)this.self.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putByteArray("infinity_item_total", itemCount.toByteArray());
        tag.putInt("infinity_item_types", this.totalAEKeyType);
        tag.putByteArray("infinity_cell_item_count", itemCount.toByteArray());
        this.self.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        this.isPersisted = true;
    }

    private BigInteger getTotalAEKey2Amounts() {
        return this.totalAEKey2Amounts;
    }

    public int getTotalAEKeyType() {
        return this.totalAEKeyType;
    }

    private boolean hasUUID() {
        CustomData data = (CustomData)this.self.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return !data.isEmpty() && data.copyTag().contains("infinity_cell_uuid");
    }

    public UUID getUUID() {
        CustomData data = (CustomData)this.self.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!data.isEmpty() && data.copyTag().contains("infinity_cell_uuid")) {
            return data.copyTag().getUUID("infinity_cell_uuid");
        }
        return null;
    }

    private Object2ObjectMap<AEKey, BigInteger> getCellStoredMap() {
        if (this.AEKey2AmountsMap == null) {
            this.AEKey2AmountsMap = new Object2ObjectOpenHashMap();
            this.loadCellStoredMap();
        }
        return this.AEKey2AmountsMap;
    }

    private void loadCellStoredMap() {
        if (this.storageManager == null) {
            return;
        }
        boolean dataCorruption = false;
        if (((CustomData)this.self.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).isEmpty()) {
            return;
        }
        ListTag keys = this.getCellStorage().keys;
        ListTag amounts = this.getCellStorage().amounts;
        if (keys.size() != amounts.size()) {
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])new Object[]{amounts.size(), keys.size()});
        }
        HolderLookup.Provider registries = this.storageManager.getRegistries();
        for (int i = 0; i < amounts.size(); ++i) {
            AEKey key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)keys.getCompound(i));
            BigInteger amount = new BigInteger(amounts.getCompound(i).getByteArray("value"));
            if (amount.compareTo(BigInteger.ZERO) <= 0 || key == null) {
                dataCorruption = true;
                continue;
            }
            this.AEKey2AmountsMap.put((Object)key, (Object)amount);
        }
        if (dataCorruption) {
            this.saveChanges();
        }
    }

    private void saveChanges() {
        this.totalAEKeyType = this.AEKey2AmountsMap.size();
        this.totalAEKey2Amounts = BigInteger.ZERO;
        for (BigInteger AEKey2Amounts : this.AEKey2AmountsMap.values()) {
            this.totalAEKey2Amounts = this.totalAEKey2Amounts.add(AEKey2Amounts);
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEItemKey itemKey;
        if (amount == 0L) {
            return 0L;
        }
        if (what instanceof AEItemKey && (itemKey = (AEItemKey)what).getItem() instanceof InfinityBigIntegerCellItem && itemKey.get(DataComponents.CUSTOM_DATA) != null) {
            return 0L;
        }
        if (this.storageManager != null && !this.hasUUID()) {
            CustomData data = (CustomData)this.self.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag tag = data.copyTag();
            UUID newUUID = UUID.randomUUID();
            tag.putUUID("infinity_cell_uuid", newUUID);
            this.self.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.storageManager.getOrCreateCell(newUUID);
            this.loadCellStoredMap();
        }
        BigInteger currentAmount = (BigInteger)this.getCellStoredMap().getOrDefault((Object)what, (Object)BigInteger.ZERO);
        if (mode == Actionable.MODULATE) {
            BigInteger newAmount = currentAmount.add(BigInteger.valueOf(amount));
            this.getCellStoredMap().put((Object)what, (Object)newAmount);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        BigInteger currentAmount = (BigInteger)this.getCellStoredMap().getOrDefault((Object)what, (Object)BigInteger.ZERO);
        if (currentAmount.compareTo(BigInteger.ZERO) > 0) {
            BigInteger requested = BigInteger.valueOf(amount);
            if (requested.compareTo(currentAmount) >= 0) {
                if (mode == Actionable.MODULATE) {
                    this.getCellStoredMap().remove((Object)what);
                    this.saveChanges();
                }
                return currentAmount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? Long.MAX_VALUE : currentAmount.longValue();
            }
            if (mode == Actionable.MODULATE) {
                this.getCellStoredMap().put((Object)what, (Object)currentAmount.subtract(requested));
                this.saveChanges();
            }
            return requested.longValue();
        }
        return 0L;
    }

    public void getAvailableStacks(KeyCounter out) {
        BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
        if (this.getCellStoredMap() == null) {
            return;
        }
        for (Object2ObjectMap.Entry entry : this.getCellStoredMap().object2ObjectEntrySet()) {
            long delta;
            long toSet;
            AEKey key = (AEKey)entry.getKey();
            BigInteger value = (BigInteger)entry.getValue();
            long existing = out.get(key);
            BigInteger sum = BigInteger.valueOf(existing).add(value);
            long l = toSet = sum.compareTo(maxLong) > 0 ? Long.MAX_VALUE : sum.longValue();
            if (existing == Long.MAX_VALUE || (delta = toSet - existing) == 0L) continue;
            out.add(key, delta);
        }
    }

    public Component getDescription() {
        return null;
    }

    public String getTotalStorage() {
        return InfinityBigIntegerCellInventory.formatBigInteger(this.totalAEKey2Amounts);
    }
}

