/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client.screen;

import com.extendedae_plus.network.SetWirelessFrequencyC2SPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class FrequencyInputScreen
extends Screen {
    private static final int WINDOW_WIDTH = 200;
    private static final int WINDOW_HEIGHT = 80;
    private final BlockPos pos;
    private final long currentFrequency;
    private EditBox frequencyInput;
    private Button confirmButton;

    private FrequencyInputScreen(BlockPos pos, long currentFrequency) {
        super((Component)Component.translatable((String)"gui.extendedae_plus.frequency_input.title"));
        this.pos = pos;
        this.currentFrequency = currentFrequency;
    }

    public static void open(BlockPos pos, long currentFrequency) {
        Minecraft.getInstance().setScreen((Screen)new FrequencyInputScreen(pos, currentFrequency));
    }

    private boolean isValidInput(String input) {
        if (input.isEmpty()) {
            return true;
        }
        if (input.equals("-")) {
            return true;
        }
        try {
            Long.parseLong(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - 200) / 2;
        int y = (this.height - 80) / 2;
        guiGraphics.fill(x, y, x + 200, y + 80, -1073741824);
        guiGraphics.fill(x, y, x + 200, y + 1, -1);
        guiGraphics.fill(x, y + 80 - 1, x + 200, y + 80, -1);
        guiGraphics.fill(x, y, x + 1, y + 80, -1);
        guiGraphics.fill(x + 200 - 1, y, x + 200, y + 80, -1);
        MutableComponent title = Component.translatable((String)"gui.extendedae_plus.frequency_input.title");
        guiGraphics.drawString(this.font, (Component)title, x + (200 - this.font.width((FormattedText)title)) / 2, y + 10, -1, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.onConfirm();
            return true;
        }
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void init() {
        super.init();
        int x = (this.width - 200) / 2;
        int y = (this.height - 80) / 2;
        this.frequencyInput = new EditBox(this.font, x + 10, y + 30, 180, 20, (Component)Component.translatable((String)"gui.extendedae_plus.frequency_input.field"));
        this.frequencyInput.setMaxLength(19);
        this.frequencyInput.setValue(String.valueOf(this.currentFrequency));
        this.frequencyInput.setFilter(this::isValidInput);
        this.frequencyInput.setFocused(true);
        this.addRenderableWidget((GuiEventListener)this.frequencyInput);
        this.confirmButton = Button.builder((Component)Component.translatable((String)"gui.extendedae_plus.frequency_input.confirm"), button -> this.onConfirm()).bounds(x + 10, y + 55, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        Button cancelButton = Button.builder((Component)Component.translatable((String)"gui.extendedae_plus.frequency_input.cancel"), button -> this.onClose()).bounds(x + 110, y + 55, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)cancelButton);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void onConfirm() {
        String input = this.frequencyInput.getValue();
        if (input.isEmpty()) {
            this.onClose();
            return;
        }
        try {
            long frequency = Long.parseLong(input);
            PacketDistributor.sendToServer((CustomPacketPayload)new SetWirelessFrequencyC2SPacket(this.pos, frequency), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

