/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.compat;

import net.neoforged.fml.ModList;

public final class UpgradeSlotCompat {
    private static Boolean APPFLUX_LOADED;
    private static Boolean APPFLUX_PATTERN_PROVIDER_MIXIN_ACTIVE;

    private UpgradeSlotCompat() {
    }

    private static boolean isAppfluxLoaded() {
        if (APPFLUX_LOADED == null) {
            try {
                APPFLUX_LOADED = ModList.get().isLoaded("appflux");
            }
            catch (Throwable t) {
                APPFLUX_LOADED = false;
            }
        }
        return APPFLUX_LOADED;
    }

    private static boolean isAppfluxPatternProviderMixinActive() {
        if (APPFLUX_PATTERN_PROVIDER_MIXIN_ACTIVE == null) {
            try {
                if (!UpgradeSlotCompat.isAppfluxLoaded()) {
                    APPFLUX_PATTERN_PROVIDER_MIXIN_ACTIVE = false;
                } else {
                    Class.forName("com.glodblock.github.appflux.mixins.MixinPatternProviderScreen");
                    APPFLUX_PATTERN_PROVIDER_MIXIN_ACTIVE = true;
                }
            }
            catch (ClassNotFoundException e) {
                APPFLUX_PATTERN_PROVIDER_MIXIN_ACTIVE = false;
            }
            catch (Throwable t) {
                APPFLUX_PATTERN_PROVIDER_MIXIN_ACTIVE = false;
            }
        }
        return APPFLUX_PATTERN_PROVIDER_MIXIN_ACTIVE;
    }

    public static boolean shouldEnableUpgradeSlots() {
        return !UpgradeSlotCompat.isAppfluxLoaded();
    }

    public static boolean shouldEnableChannelCard() {
        return true;
    }

    public static boolean shouldAddUpgradePanelToScreen() {
        return true;
    }

    public static boolean shouldUseLowPriorityMode() {
        return UpgradeSlotCompat.isAppfluxPatternProviderMixinActive();
    }

    public static int getRecommendedMixinPriority() {
        return UpgradeSlotCompat.isAppfluxPatternProviderMixinActive() ? 1500 : 2000;
    }
}

