/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jade;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum WirelessTransceiverJadePluginComponents implements IBlockComponentProvider
{
    FREQUENCY("wt_frequency"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.contains("frequency")) {
                long frequency = data.getLong("frequency");
                tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.frequency", (Object[])new Object[]{frequency}));
            }
        }
    }
    ,
    MODE("wt_master_mode"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.contains("masterMode")) {
                boolean masterMode = data.getBoolean("masterMode");
                tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.master_mode", (Object[])new Object[]{masterMode ? "\u4e3b\u6a21\u5f0f" : "\u4ece\u6a21\u5f0f"}));
            }
        }
    }
    ,
    MASTER_LOCATION("wt_master_location"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.contains("masterMode") && !data.getBoolean("masterMode") && data.contains("masterPos")) {
                String customName;
                BlockPos pos = BlockPos.of((long)data.getLong("masterPos"));
                String dim = data.contains("masterDim") ? data.getString("masterDim") : "";
                String string = customName = data.contains("customName") ? data.getString("customName") : null;
                if (customName != null) {
                    tooltip.add((Component)Component.literal((String)("\u4e3b\u8282\u70b9: " + customName + "(" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ")")));
                } else {
                    tooltip.add((Component)Component.literal((String)("\u4e3b\u8282\u70b9\u4f4d\u7f6e: (" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ")")));
                }
                if (!dim.isEmpty()) {
                    tooltip.add((Component)Component.literal((String)("\u7ef4\u5ea6: " + dim)));
                }
            }
        }
    }
    ,
    LOCKED("wt_locked"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.contains("locked")) {
                boolean locked = data.getBoolean("locked");
                tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.locked", (Object[])new Object[]{locked ? "\u5df2\u9501\u5b9a" : "\u672a\u9501\u5b9a"}));
            }
        }
    }
    ,
    NETWORK_USABLE("wt_network_usable"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.contains("networkUsable")) {
                boolean usable = data.getBoolean("networkUsable");
                tooltip.add((Component)Component.literal((String)(usable ? "\u8bbe\u5907\u5728\u7ebf" : "\u8bbe\u5907\u79bb\u7ebf")));
            }
        }
    }
    ,
    OWNER("wt_owner"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.contains("ownerName")) {
                String ownerName = data.getString("ownerName");
                tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.owner", (Object[])new Object[]{ownerName}));
            } else if (data.hasUUID("placerId")) {
                UUID placerId = data.getUUID("placerId");
                tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.owner", (Object[])new Object[]{placerId.toString().substring(0, 8) + "..."}));
            } else {
                tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.owner.public"));
            }
        }
    }
    ,
    CHANNELS("wt_channels"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.contains("usedChannels") && data.contains("maxChannels")) {
                int usedChannels = data.getInt("usedChannels");
                int maxChannels = data.getInt("maxChannels");
                if (maxChannels <= 0) {
                    tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.channels", (Object[])new Object[]{usedChannels}));
                } else {
                    tooltip.add((Component)Component.translatable((String)"extendedae_plus.tooltip.channels_of", (Object[])new Object[]{usedChannels, maxChannels}));
                }
            }
        }
    };

    private final ResourceLocation uid;

    private WirelessTransceiverJadePluginComponents(String path) {
        this.uid = ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)path);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public final void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data == null) {
            return;
        }
        this.add(accessor, tooltip, config, data);
    }

    protected abstract void add(BlockAccessor var1, ITooltip var2, IPluginConfig var3, CompoundTag var4);
}

