/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.items.materials;

import appeng.items.materials.UpgradeCardItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ChannelCardItem
extends UpgradeCardItem {
    private static final String TAG_CHANNEL = "channel";
    private static final String TAG_OWNER_UUID = "ownerUUID";
    private static final String TAG_TEAM_NAME = "teamName";

    public ChannelCardItem(Item.Properties properties) {
        super(properties);
    }

    private static void setChannel(ItemStack stack, long channel) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putLong(TAG_CHANNEL, channel);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static long getChannel(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.contains(TAG_CHANNEL) ? tag.getLong(TAG_CHANNEL) : 0L;
    }

    public static void setOwnerUUID(ItemStack stack, UUID ownerUUID) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putUUID(TAG_OWNER_UUID, ownerUUID);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    @Nullable
    public static UUID getOwnerUUID(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.hasUUID(TAG_OWNER_UUID) ? tag.getUUID(TAG_OWNER_UUID) : null;
    }

    public static void setTeamName(ItemStack stack, String teamName) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putString(TAG_TEAM_NAME, teamName);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    @Nullable
    public static String getTeamName(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.contains(TAG_TEAM_NAME) ? tag.getString(TAG_TEAM_NAME) : null;
    }

    public static void clearOwner(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.remove(TAG_OWNER_UUID);
        tag.remove(TAG_TEAM_NAME);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        long ch = ChannelCardItem.getChannel(stack);
        if (ch == 0L) {
            lines.add((Component)Component.translatable((String)"item.extendedae_plus.channel_card.channel.unset"));
        } else {
            lines.add((Component)Component.translatable((String)"item.extendedae_plus.channel_card.channel", (Object[])new Object[]{ch}));
        }
        UUID ownerUUID = ChannelCardItem.getOwnerUUID(stack);
        String teamName = ChannelCardItem.getTeamName(stack);
        if (ownerUUID != null) {
            if (teamName != null && !teamName.isEmpty()) {
                lines.add((Component)Component.translatable((String)"item.extendedae_plus.channel_card.owner.team", (Object[])new Object[]{teamName}));
            } else {
                lines.add((Component)Component.translatable((String)"item.extendedae_plus.channel_card.owner.player", (Object[])new Object[]{ownerUUID.toString().substring(0, 8)}));
            }
        } else {
            lines.add((Component)Component.translatable((String)"item.extendedae_plus.channel_card.owner.unset"));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            long ch = ChannelCardItem.getChannel(stack);
            long next = player.isShiftKeyDown() ? Math.max(0L, ch - 1L) : ch + 1L;
            if (next != ch) {
                ChannelCardItem.setChannel(stack, next);
                player.displayClientMessage((Component)Component.translatable((String)"item.extendedae_plus.channel_card.set", (Object[])new Object[]{next}), true);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.isShiftKeyDown()) {
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }
}

