/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2;

import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.items.tools.quartz.QuartzCuttingKnifeItem;
import com.extendedae_plus.util.ExtendedAELogger;
import com.mojang.blaze3d.platform.Window;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={QuartzCuttingKnifeItem.class})
public abstract class QuartzCuttingKnifeItemMixin {
    @Unique
    private String eap$cleanBlockName(String name) {
        if (name == null || name.isBlank()) {
            return name;
        }
        name = name.replaceAll("\u00a7[0-9a-fk-or]", "");
        name = name.trim();
        name = name.replaceAll("[\\[\\](){}]", "");
        return name;
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void eap$copyNameOnShiftRightClick(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!level.isClientSide()) {
            return;
        }
        if (player == null || !player.isCrouching()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        HitResult hr = mc.hitResult;
        if (!(hr instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult bhr = (BlockHitResult)hr;
        BlockPos pos = bhr.getBlockPos();
        BlockState state = level.getBlockState(pos);
        if (state == null || state.isAir()) {
            return;
        }
        String name = this.eap$getBlockName(level, pos, hr.getLocation());
        name = this.eap$cleanBlockName(name);
        boolean success = QuartzCuttingKnifeItemMixin.eap$tryCopyToClipboard(Minecraft.getInstance(), name);
        player.displayClientMessage((Component)Component.literal((String)(success ? "\u5df2\u590d\u5236\u65b9\u5757/\u90e8\u4ef6\u540d: " + name : "\u590d\u5236\u5931\u8d25\uff1a\u6574\u5408\u5305\u53ef\u80fd\u9650\u5236\u526a\u8d34\u677f\u6216\u672a\u805a\u7126\u7a97\u53e3")), true);
        ItemStack held = player.getItemInHand(hand);
        cir.setReturnValue((Object)new InteractionResultHolder(InteractionResult.SUCCESS, (Object)held));
    }

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void eap$copyNameOnShiftRightClickUseOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (!level.isClientSide() || player == null || !player.isCrouching()) {
            return;
        }
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            return;
        }
        String name = this.eap$getBlockName(level, pos, context.getClickLocation());
        name = this.eap$cleanBlockName(name);
        boolean success = QuartzCuttingKnifeItemMixin.eap$tryCopyToClipboard(Minecraft.getInstance(), name);
        player.displayClientMessage((Component)Component.literal((String)(success ? "\u5df2\u590d\u5236\u65b9\u5757/\u90e8\u4ef6\u540d: " + name : "\u590d\u5236\u5931\u8d25\uff1a\u6574\u5408\u5305\u53ef\u80fd\u9650\u5236\u526a\u8d34\u677f\u6216\u672a\u805a\u7126\u7a97\u53e3")), true);
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }

    @Unique
    private String eap$getBlockName(Level level, BlockPos pos, Vec3 clickLocation) {
        String gtceuName;
        Nameable nameable;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BlockState state = level.getBlockState(pos);
        if (blockEntity instanceof Nameable && (nameable = (Nameable)blockEntity).getCustomName() != null) {
            return nameable.getCustomName().getString();
        }
        String ae2Name = this.eap$handleAE2Block(blockEntity, clickLocation);
        if (ae2Name != null && !ae2Name.isBlank()) {
            return ae2Name;
        }
        if (ModList.get().isLoaded("gtceu") && (gtceuName = this.eap$handleGTCEuBlock(blockEntity)) != null && !gtceuName.isBlank()) {
            return gtceuName;
        }
        return state.getBlock().getName().getString();
    }

    @Unique
    private String eap$handleGTCEuBlock(BlockEntity blockEntity) {
        try {
            Class<?> metaMachineBlockEntityClass = Class.forName("com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity");
            Class<?> workableElectricMultiblockMachineClass = Class.forName("com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine");
            if (metaMachineBlockEntityClass.isInstance(blockEntity)) {
                Field metaMachineField = metaMachineBlockEntityClass.getDeclaredField("metaMachine");
                metaMachineField.setAccessible(true);
                Object metaMachine = metaMachineField.get(blockEntity);
                if (workableElectricMultiblockMachineClass.isInstance(metaMachine)) {
                    Method getRecipeTypeMethod = workableElectricMultiblockMachineClass.getMethod("getRecipeType", new Class[0]);
                    getRecipeTypeMethod.setAccessible(true);
                    Object recipeType = getRecipeTypeMethod.invoke(metaMachine, new Object[0]);
                    if (recipeType != null) {
                        String recipeName = recipeType.toString().replace("gtceu:", "");
                        String translationKey = "gtceu." + recipeName;
                        return I18n.get((String)translationKey, (Object[])new Object[]{recipeName});
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            ExtendedAELogger.LOGGER.info("GregTech CEu \u7c7b\u672a\u627e\u5230\uff0c\u8df3\u8fc7\u914d\u65b9\u7ffb\u8bd1\u5904\u7406");
            return null;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            ExtendedAELogger.LOGGER.error("\u5904\u7406 GTCEu \u914d\u65b9\u7ffb\u8bd1\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    @Unique
    private String eap$handleAE2Block(BlockEntity blockEntity, Vec3 clickLocation) {
        if (blockEntity instanceof IPartHost) {
            ItemStack stack;
            IPartHost partHost = (IPartHost)blockEntity;
            SelectedPart sel = partHost.selectPartWorld(clickLocation);
            if (sel.part != null) {
                ItemStack stack2 = new ItemStack((ItemLike)sel.part.getPartItem());
                return stack2.getHoverName().getString();
            }
            if (sel.facade != null && !(stack = sel.facade.getItemStack()).isEmpty()) {
                return stack.getHoverName().getString();
            }
        }
        return null;
    }

    @Unique
    private static boolean eap$tryCopyToClipboard(Minecraft mc, String text) {
        if (text == null || text.isBlank()) {
            return false;
        }
        if (!mc.isSameThread()) {
            AtomicBoolean result = new AtomicBoolean(false);
            CountDownLatch latch = new CountDownLatch(1);
            mc.execute(() -> {
                try {
                    result.set(QuartzCuttingKnifeItemMixin.eap$doCopy(mc, text));
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ExtendedAELogger.LOGGER.error("\u526a\u8d34\u677f\u590d\u5236\u7ebf\u7a0b\u4e2d\u65ad: {}", (Object)e.getMessage());
            }
            return result.get();
        }
        return QuartzCuttingKnifeItemMixin.eap$doCopy(mc, text);
    }

    @Unique
    private static boolean eap$doCopy(Minecraft mc, String text) {
        try {
            mc.keyboardHandler.setClipboard(text);
            return true;
        }
        catch (Throwable throwable) {
            try {
                long handle;
                Window window = mc.getWindow();
                long l = handle = window == null ? 0L : window.getWindow();
                if (handle != 0L) {
                    GLFW.glfwSetClipboardString((long)handle, (CharSequence)text);
                    return true;
                }
            }
            catch (Throwable window) {
                // empty catch block
            }
            try {
                long current = GLFW.glfwGetCurrentContext();
                if (current != 0L) {
                    GLFW.glfwSetClipboardString((long)current, (CharSequence)text);
                    return true;
                }
            }
            catch (Throwable current) {
                // empty catch block
            }
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(text), null);
                return true;
            }
            catch (Throwable throwable2) {
                return false;
            }
        }
    }
}

