/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.autopattern;

import appeng.api.crafting.IPatternDetails;
import appeng.crafting.CraftingCalculation;
import appeng.crafting.CraftingPlan;
import appeng.crafting.inv.CraftingSimulationState;
import appeng.me.service.CraftingService;
import com.extendedae_plus.api.smartDoubling.ICraftingCalculationExt;
import com.extendedae_plus.api.smartDoubling.ISmartDoublingAwarePattern;
import com.extendedae_plus.config.ModConfigs;
import com.extendedae_plus.mixin.ae2.autopattern.CraftingSimulationStateAccessor;
import com.extendedae_plus.util.smartDoubling.PatternScaler;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingSimulationState.class}, remap=false)
public abstract class CraftingSimulationStateMixin {
    @Inject(method={"buildCraftingPlan"}, at={@At(value="HEAD")})
    private static void onBuildCraftingPlan(CraftingSimulationState state, CraftingCalculation calculation, long calculatedAmount, CallbackInfoReturnable<CraftingPlan> cir) {
        CraftingSimulationStateAccessor accessor = (CraftingSimulationStateAccessor)state;
        Map<IPatternDetails, Long> crafts = accessor.getCrafts();
        LinkedHashMap<IPatternDetails, Long> finalCrafts = new LinkedHashMap<IPatternDetails, Long>();
        for (Map.Entry<IPatternDetails, Long> entry : crafts.entrySet()) {
            IPatternDetails processingPattern = entry.getKey();
            long totalAmount = entry.getValue();
            if (!(processingPattern instanceof ISmartDoublingAwarePattern)) {
                finalCrafts.put(processingPattern, totalAmount);
                continue;
            }
            ISmartDoublingAwarePattern aware = (ISmartDoublingAwarePattern)processingPattern;
            boolean allowScaling = aware.eap$allowScaling();
            int perCraftLimit = aware.eap$getMultiplierLimit();
            if (!allowScaling || totalAmount <= 1L) {
                finalCrafts.put(processingPattern, totalAmount);
                continue;
            }
            if (perCraftLimit <= 0 && (Integer)ModConfigs.SMART_SCALING_MAX_MULTIPLIER.get() > 0) {
                perCraftLimit = (Integer)ModConfigs.SMART_SCALING_MAX_MULTIPLIER.get();
            }
            if (perCraftLimit <= 0) {
                if (((Boolean)ModConfigs.PROVIDER_ROUND_ROBIN_ENABLE.getRaw()).booleanValue()) {
                    long countBase;
                    CraftingService craftingService = (CraftingService)((ICraftingCalculationExt)calculation).getGrid().getCraftingService();
                    int providerCount = Math.max(Iterables.size((Iterable)craftingService.getProviders(processingPattern)), 1);
                    if (totalAmount < (long)providerCount) {
                        providerCount = (int)totalAmount;
                    }
                    long base = totalAmount / (long)providerCount;
                    long remainder = totalAmount % (long)providerCount;
                    if (remainder > 0L) {
                        IPatternDetails scaledPlus = PatternScaler.createScaled(processingPattern, base + 1L);
                        finalCrafts.merge(scaledPlus, remainder, Long::sum);
                    }
                    if ((countBase = (long)providerCount - remainder) <= 0L) continue;
                    IPatternDetails scaledBase = PatternScaler.createScaled(processingPattern, base);
                    finalCrafts.merge(scaledBase, countBase, Long::sum);
                    continue;
                }
                IPatternDetails scaled = PatternScaler.createScaled(processingPattern, totalAmount);
                finalCrafts.put(scaled, 1L);
                continue;
            }
            long fullCrafts = totalAmount / (long)perCraftLimit;
            long remainder = totalAmount % (long)perCraftLimit;
            if (fullCrafts > 0L) {
                IPatternDetails scaledFull = PatternScaler.createScaled(processingPattern, perCraftLimit);
                finalCrafts.put(scaledFull, fullCrafts);
            }
            if (remainder <= 0L) continue;
            IPatternDetails scaledRem = PatternScaler.createScaled(processingPattern, remainder);
            finalCrafts.put(scaledRem, 1L);
        }
        crafts.clear();
        crafts.putAll(finalCrafts);
    }
}

