/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.helpers;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.ae.wireless.endpoint.InterfaceNodeEndpointImpl;
import com.extendedae_plus.api.bridge.InterfaceWirelessLinkBridge;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.items.materials.ChannelCardItem;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InterfaceLogic.class})
public abstract class InterfaceLogicChannelCardMixin
implements InterfaceWirelessLinkBridge {
    @Shadow(remap=false)
    protected InterfaceLogicHost host;
    @Shadow(remap=false)
    protected IManagedGridNode mainNode;
    @Unique
    private WirelessSlaveLink eap$link;
    @Unique
    private long eap$lastChannel = -1L;
    @Unique
    private UUID eap$lastOwner;
    @Unique
    private boolean eap$clientConnected = false;
    @Unique
    private boolean eap$hasInitialized = false;
    @Unique
    private int eap$delayedInitTicks = 0;

    @Shadow(remap=false)
    public abstract IUpgradeInventory getUpgrades();

    @Shadow(remap=false)
    public abstract IGridNode getActionableNode();

    @Inject(method={"onUpgradesChanged"}, at={@At(value="TAIL")}, remap=false)
    private void eap$onUpgradesChangedTail(CallbackInfo ci) {
        this.eap$lastChannel = -1L;
        this.eap$hasInitialized = false;
        this.eap$initializeChannelLink();
    }

    @Inject(method={"gridChanged"}, at={@At(value="TAIL")}, remap=false)
    private void eap$afterGridChanged(CallbackInfo ci) {
        this.eap$lastChannel = -1L;
        this.eap$hasInitialized = false;
        this.eap$delayedInitTicks = 10;
        if (this.mainNode != null) {
            this.mainNode.ifPresent((grid, node) -> {
                try {
                    grid.getTickManager().wakeDevice(node);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")}, remap=false)
    private void eap$afterReadNBT(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        this.eap$lastChannel = -1L;
        this.eap$hasInitialized = false;
        this.eap$initializeChannelLink();
    }

    @Inject(method={"clearContent"}, at={@At(value="HEAD")}, remap=false)
    private void eap$onClearContent(CallbackInfo ci) {
        if (this.eap$link != null) {
            this.eap$link.onUnloadOrRemove();
        }
    }

    @Override
    public void eap$updateWirelessLink() {
        if (this.eap$link != null) {
            this.eap$link.updateStatus();
        }
    }

    @Override
    public boolean eap$isWirelessConnected() {
        if (this.host.getBlockEntity() != null && this.host.getBlockEntity().getLevel() != null && this.host.getBlockEntity().getLevel().isClientSide) {
            return this.eap$clientConnected;
        }
        return this.eap$link != null && this.eap$link.isConnected();
    }

    @Override
    public void eap$setClientWirelessState(boolean connected) {
        this.eap$clientConnected = connected;
    }

    @Override
    public boolean eap$hasTickInitialized() {
        return this.eap$hasInitialized;
    }

    @Override
    public void eap$setTickInitialized(boolean initialized) {
        this.eap$hasInitialized = initialized;
    }

    @Override
    @Unique
    public void eap$initializeChannelLink() {
        if (this.host.getBlockEntity() != null && this.host.getBlockEntity().getLevel() != null && this.host.getBlockEntity().getLevel().isClientSide) {
            return;
        }
        if (this.eap$hasInitialized) {
            return;
        }
        if (this.mainNode == null || this.mainNode.getNode() == null) {
            return;
        }
        try {
            boolean sameOwner;
            long channel = 0L;
            boolean found = false;
            UUID owner = null;
            for (ItemStack stack : this.getUpgrades()) {
                if (stack.isEmpty() || stack.getItem() != ModItems.CHANNEL_CARD.get()) continue;
                channel = ChannelCardItem.getChannel(stack);
                owner = ChannelCardItem.getOwnerUUID(stack);
                if (owner == null) {
                    owner = this.eap$getFallbackOwner();
                }
                found = true;
                break;
            }
            if (!found) {
                if (this.eap$link != null) {
                    this.eap$link.setPlacerId(null);
                    this.eap$link.setFrequency(0L);
                    this.eap$link.updateStatus();
                }
                this.eap$hasInitialized = true;
                this.eap$lastChannel = 0L;
                this.eap$lastOwner = null;
                try {
                    this.host.saveChanges();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.mainNode.ifPresent((grid, node) -> {
                        try {
                            grid.getTickManager().wakeDevice(node);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            boolean bl = sameOwner = this.eap$lastOwner == null && owner == null || this.eap$lastOwner != null && this.eap$lastOwner.equals(owner);
            if (this.eap$link != null && this.eap$lastChannel == channel && sameOwner) {
                this.eap$hasInitialized = this.eap$link.isConnected();
                return;
            }
            if (this.eap$link == null) {
                InterfaceNodeEndpointImpl endpoint = new InterfaceNodeEndpointImpl(this.host, () -> this.mainNode.getNode());
                this.eap$link = new WirelessSlaveLink(endpoint);
            }
            this.eap$link.setPlacerId(owner);
            this.eap$link.setFrequency(channel);
            this.eap$link.updateStatus();
            this.eap$lastChannel = channel;
            this.eap$lastOwner = owner;
            try {
                this.host.saveChanges();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.mainNode.ifPresent((grid, node) -> {
                    try {
                        grid.getTickManager().wakeDevice(node);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.eap$link.isConnected()) {
                this.eap$hasInitialized = true;
            } else {
                this.eap$hasInitialized = false;
                this.eap$delayedInitTicks = Math.max(this.eap$delayedInitTicks, 5);
                try {
                    this.mainNode.ifPresent((grid, node) -> {
                        try {
                            grid.getTickManager().wakeDevice(node);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void eap$handleDelayedInit() {
        if (this.host.getBlockEntity() != null && this.host.getBlockEntity().getLevel() != null && this.host.getBlockEntity().getLevel().isClientSide) {
            return;
        }
        if (!this.eap$hasInitialized) {
            if (this.mainNode == null || this.mainNode.getNode() == null) {
                if (this.eap$delayedInitTicks > 0) {
                    --this.eap$delayedInitTicks;
                }
                if (this.eap$delayedInitTicks == 0) {
                    this.eap$delayedInitTicks = 5;
                    try {
                        this.mainNode.ifPresent((grid, node) -> {
                            try {
                                grid.getTickManager().wakeDevice(node);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                this.eap$initializeChannelLink();
            }
        }
    }

    @Unique
    private UUID eap$getFallbackOwner() {
        if (this.mainNode != null && this.mainNode.getNode() != null) {
            return this.mainNode.getNode().getOwningPlayerProfileId();
        }
        return null;
    }
}

