/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.helpers;

import appeng.api.networking.IManagedGridNode;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import com.extendedae_plus.util.ExtendedAELogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderLogic.class}, priority=1100, remap=false)
public abstract class PatternProviderLogicUpgradesMixin {
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Unique
    private IUpgradeInventory eap$upgrades = UpgradeInventories.empty();
    @Unique
    private boolean eap$hasAppliedFlux = false;
    @Unique
    private boolean eap$upgradesInitialized = false;

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void eap$initUpgrades(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        try {
            this.eap$hasAppliedFlux = ModList.get().isLoaded("appflux");
            if (this.eap$hasAppliedFlux) {
                this.eap$extendAppliedFluxUpgrades();
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668][\u5347\u7ea7\u69fd] \u521d\u59cb\u5316\u5931\u8d25", t);
        }
    }

    @Unique
    private void eap$extendAppliedFluxUpgrades() {
        block14: {
            try {
                Field f2;
                IUpgradeInventory existingUpgrades = null;
                try {
                    f2 = this.getClass().getDeclaredField("af_upgrades");
                    f2.setAccessible(true);
                    existingUpgrades = (IUpgradeInventory)f2.get(this);
                }
                catch (Throwable f2) {
                    // empty catch block
                }
                if (existingUpgrades != null && existingUpgrades != UpgradeInventories.empty()) {
                    int targetSlots;
                    int currentSlots = existingUpgrades.size();
                    if (currentSlots < (targetSlots = 2)) {
                        int i;
                        ItemStack[] savedItems = new ItemStack[currentSlots];
                        for (i = 0; i < currentSlots; ++i) {
                            savedItems[i] = existingUpgrades.getStackInSlot(i).copy();
                        }
                        this.eap$upgrades = UpgradeInventories.forMachine((ItemLike)this.host.getTerminalIcon().getItem(), (int)targetSlots, this::eap$onUpgradesChanged);
                        for (i = 0; i < savedItems.length; ++i) {
                            this.eap$upgrades.setItemDirect(i, savedItems[i]);
                        }
                        try {
                            Field f3 = this.getClass().getDeclaredField("af_upgrades");
                            f3.setAccessible(true);
                            f3.set(this, this.eap$upgrades);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.eap$upgradesInitialized = true;
                        break block14;
                    }
                    this.eap$upgrades = existingUpgrades;
                    this.eap$upgradesInitialized = true;
                    break block14;
                }
                this.eap$upgrades = UpgradeInventories.forMachine((ItemLike)this.host.getTerminalIcon().getItem(), (int)2, this::eap$onUpgradesChanged);
                try {
                    f2 = this.getClass().getDeclaredField("af_upgrades");
                    f2.setAccessible(true);
                    f2.set(this, this.eap$upgrades);
                }
                catch (Throwable f4) {
                    // empty catch block
                }
                this.eap$upgradesInitialized = true;
            }
            catch (Throwable t) {
                ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668][\u5347\u7ea7\u69fd] \u6269\u5c55 AppliedFlux \u5347\u7ea7\u69fd\u5931\u8d25", t);
                this.eap$upgrades = UpgradeInventories.forMachine((ItemLike)this.host.getTerminalIcon().getItem(), (int)2, this::eap$onUpgradesChanged);
                try {
                    Field f = this.getClass().getDeclaredField("af_upgrades");
                    f.setAccessible(true);
                    f.set(this, this.eap$upgrades);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.eap$upgradesInitialized = true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Unique
    private void eap$onUpgradesChanged() {
        try {
            this.host.saveChanges();
            if (!this.eap$hasAppliedFlux) return;
            try {
                Method afMethod = this.getClass().getDeclaredMethod("af_onUpgradesChanged", new Class[0]);
                afMethod.setAccessible(true);
                afMethod.invoke((Object)this, new Object[0]);
                return;
            }
            catch (NoSuchMethodException afMethod) {}
            finally {
                return;
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668][\u5347\u7ea7\u69fd] onUpgradesChanged \u5904\u7406\u5931\u8d25", t);
        }
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void eap$saveUpgrades(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        try {
            if (this.eap$hasAppliedFlux) {
                return;
            }
            if (this.eap$upgradesInitialized && this.eap$upgrades != null && this.eap$upgrades != UpgradeInventories.empty()) {
                if (this.eap$hasAppliedFlux) {
                    this.eap$upgrades.writeToNBT(tag, "eap_upgrades", registries);
                } else {
                    this.eap$upgrades.writeToNBT(tag, "upgrades", registries);
                }
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668][\u5347\u7ea7\u69fd] \u4fdd\u5b58\u5347\u7ea7\u69fd\u5931\u8d25", t);
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eap$loadUpgrades(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        try {
            this.eap$hasAppliedFlux = ModList.get().isLoaded("appflux");
            if (!this.eap$upgradesInitialized) {
                if (this.eap$hasAppliedFlux) {
                    this.eap$extendAppliedFluxUpgrades();
                } else {
                    this.eap$upgrades = UpgradeInventories.forMachine((ItemLike)this.host.getTerminalIcon().getItem(), (int)1, this::eap$onUpgradesChanged);
                    this.eap$upgradesInitialized = true;
                }
            }
            if (!this.eap$hasAppliedFlux && this.eap$upgrades != null && this.eap$upgrades != UpgradeInventories.empty() && tag.contains("upgrades")) {
                this.eap$upgrades.readFromNBT(tag, "upgrades", registries);
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668][\u5347\u7ea7\u69fd] \u52a0\u8f7d\u5347\u7ea7\u69fd\u5931\u8d25", t);
        }
    }

    @Inject(method={"addDrops"}, at={@At(value="TAIL")})
    private void eap$dropUpgrades(List<ItemStack> drops, CallbackInfo ci) {
        try {
            if (this.eap$hasAppliedFlux) {
                return;
            }
            if (this.eap$upgradesInitialized && this.eap$upgrades != null) {
                for (ItemStack is : this.eap$upgrades) {
                    if (is.isEmpty()) continue;
                    drops.add(is);
                }
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668][\u5347\u7ea7\u69fd] \u6dfb\u52a0\u6389\u843d\u5931\u8d25", t);
        }
    }

    @Inject(method={"clearContent"}, at={@At(value="TAIL")})
    private void eap$clearUpgrades(CallbackInfo ci) {
        try {
            if (this.eap$hasAppliedFlux) {
                return;
            }
            if (this.eap$upgradesInitialized && this.eap$upgrades != null) {
                this.eap$upgrades.clear();
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668][\u5347\u7ea7\u69fd] \u6e05\u7a7a\u5347\u7ea7\u69fd\u5931\u8d25", t);
        }
    }
}

