/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.menu;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.definitions.AEItems;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import com.extendedae_plus.mixin.ae2.accessor.MEStorageMenuAccessor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternEncodingTermMenu.class})
public abstract class PatternEncodingTermMenuMixin {
    @Unique
    private boolean eap$blankAutoFilled = false;
    @Shadow
    private RestrictedInputSlot blankPatternSlot;

    @Unique
    private void eap$tryFill(IPatternTerminalMenuHost host, Inventory ip) {
        try {
            boolean canInteract;
            PatternEncodingTermMenu self = (PatternEncodingTermMenu)this;
            if (ip.player.level().isClientSide()) {
                return;
            }
            MEStorageMenuAccessor acc = (MEStorageMenuAccessor)self;
            MEStorage storage = acc.getStorage();
            IEnergySource power = acc.getEnergySource();
            boolean bl = canInteract = storage != null && power != null && self.getLinkStatus().connected();
            if (!canInteract) {
                return;
            }
            if (storage == null || power == null) {
                return;
            }
            InternalInventory blankInv = host.getLogic().getBlankPatternInv();
            ItemStack current = blankInv.getStackInSlot(0);
            int limit = blankInv.getSlotLimit(0);
            int space = Math.max(0, limit - current.getCount());
            if ((space = Math.min(space, AEItems.BLANK_PATTERN.stack(1).getMaxStackSize())) <= 0) {
                return;
            }
            AEItemKey blankKey = AEItemKey.of((ItemLike)AEItems.BLANK_PATTERN.asItem());
            long extracted = StorageHelper.poweredExtraction((IEnergySource)power, (MEStorage)storage, (AEKey)blankKey, (long)space, (IActionSource)self.getActionSource());
            if (extracted <= 0L) {
                return;
            }
            int toInsert = (int)Math.min(extracted, (long)space);
            ItemStack stackInSlot = this.blankPatternSlot.getItem();
            if (stackInSlot.isEmpty()) {
                this.blankPatternSlot.set(AEItems.BLANK_PATTERN.stack(toInsert));
            } else {
                stackInSlot.grow(toInsert);
                this.blankPatternSlot.set(stackInSlot);
            }
            long leftover = extracted - (long)toInsert;
            if (leftover > 0L) {
                StorageHelper.poweredInsert((IEnergySource)power, (MEStorage)storage, (AEKey)blankKey, (long)leftover, (IActionSource)self.getActionSource());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/IPatternTerminalMenuHost;Z)V"}, at={@At(value="TAIL")})
    private void eap$autoFillBlankPattern(MenuType<?> menuType, int id, Inventory ip, IPatternTerminalMenuHost host, boolean bindInventory, CallbackInfo ci) {
        this.eap$tryFill(host, ip);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/IPatternTerminalMenuHost;)V"}, at={@At(value="TAIL")})
    private void eap$autoFillCtor3(int id, Inventory ip, IPatternTerminalMenuHost host, CallbackInfo ci) {
        this.eap$tryFill(host, ip);
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="TAIL")})
    private void eap$retryFillAfterPower(CallbackInfo ci) {
        boolean canInteract;
        if (this.eap$blankAutoFilled) {
            return;
        }
        PatternEncodingTermMenu self = (PatternEncodingTermMenu)this;
        MEStorageMenuAccessor acc = (MEStorageMenuAccessor)self;
        MEStorage storage = acc.getStorage();
        IEnergySource power = acc.getEnergySource();
        Player player = self.getPlayerInventory().player;
        if (player.level().isClientSide()) {
            return;
        }
        boolean bl = canInteract = storage != null && power != null && self.getLinkStatus().connected();
        if (!canInteract) {
            return;
        }
        IPatternTerminalMenuHost host = (IPatternTerminalMenuHost)self.getTarget();
        InternalInventory blankInv = host.getLogic().getBlankPatternInv();
        ItemStack current = blankInv.getStackInSlot(0);
        int limit = blankInv.getSlotLimit(0);
        int space = Math.max(0, limit - current.getCount());
        if ((space = Math.min(space, AEItems.BLANK_PATTERN.stack(1).getMaxStackSize())) <= 0) {
            this.eap$blankAutoFilled = true;
            return;
        }
        AEItemKey blankKey = AEItemKey.of((ItemLike)AEItems.BLANK_PATTERN.asItem());
        long extracted = StorageHelper.poweredExtraction((IEnergySource)power, (MEStorage)storage, (AEKey)blankKey, (long)space, (IActionSource)self.getActionSource());
        if (extracted <= 0L) {
            return;
        }
        int toInsert = (int)Math.min(extracted, (long)space);
        ItemStack stackInSlot = this.blankPatternSlot.getItem();
        if (stackInSlot.isEmpty()) {
            this.blankPatternSlot.set(AEItems.BLANK_PATTERN.stack(toInsert));
        } else {
            stackInSlot.grow(toInsert);
            this.blankPatternSlot.set(stackInSlot);
        }
        long leftover = extracted - (long)toInsert;
        if (leftover > 0L) {
            StorageHelper.poweredInsert((IEnergySource)power, (MEStorage)storage, (AEKey)blankKey, (long)leftover, (IActionSource)self.getActionSource());
        }
        this.eap$blankAutoFilled = true;
    }
}

