/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.parts.storagebus;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.parts.AEBasePart;
import appeng.parts.storagebus.StorageBusPart;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.ae.wireless.endpoint.GenericNodeEndpointImpl;
import com.extendedae_plus.api.bridge.InterfaceWirelessLinkBridge;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.items.materials.ChannelCardItem;
import com.extendedae_plus.util.ExtendedAELogger;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StorageBusPart.class}, remap=false)
public abstract class StorageBusPartChannelCardMixin
implements InterfaceWirelessLinkBridge,
IUpgradeableObject {
    @Unique
    private WirelessSlaveLink eap$link;
    @Unique
    private long eap$lastChannel = -1L;
    @Unique
    private UUID eap$lastOwner;
    @Unique
    private boolean eap$clientConnected = false;

    @Inject(method={"upgradesChanged"}, at={@At(value="TAIL")})
    private void eap$onUpgradesChanged(CallbackInfo ci) {
        if (!((AEBasePart)this).isClientSide()) {
            this.eap$initializeChannelLink();
        }
    }

    @Inject(method={"onMainNodeStateChanged"}, at={@At(value="TAIL")})
    private void eap$onMainNodeStateChanged(IGridNodeListener.State reason, CallbackInfo ci) {
        if (reason == IGridNodeListener.State.GRID_BOOT && !((AEBasePart)this).isClientSide()) {
            this.eap$initializeChannelLink();
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eap$afterReadFromNBT(CompoundTag extra, HolderLookup.Provider registries, CallbackInfo ci) {
        if (!((AEBasePart)this).isClientSide()) {
            this.eap$lastChannel = -1L;
            this.eap$initializeChannelLink();
        }
    }

    @Override
    public void eap$updateWirelessLink() {
        if (this.eap$link != null) {
            this.eap$link.updateStatus();
        }
    }

    @Override
    public boolean eap$isWirelessConnected() {
        if (((AEBasePart)this).isClientSide()) {
            return this.eap$clientConnected;
        }
        return this.eap$link != null && this.eap$link.isConnected();
    }

    @Override
    public void eap$setClientWirelessState(boolean connected) {
        this.eap$clientConnected = connected;
    }

    @Override
    @Unique
    public void eap$initializeChannelLink() {
        if (((AEBasePart)this).isClientSide()) {
            return;
        }
        try {
            boolean sameOwner;
            IUpgradeInventory inv = this.getUpgrades();
            long channel = 0L;
            boolean found = false;
            UUID owner = null;
            for (ItemStack stack : inv) {
                if (stack.isEmpty() || stack.getItem() != ModItems.CHANNEL_CARD.get()) continue;
                channel = ChannelCardItem.getChannel(stack);
                owner = ChannelCardItem.getOwnerUUID(stack);
                if (owner == null) {
                    owner = this.eap$getFallbackOwner();
                }
                found = true;
                break;
            }
            boolean bl = sameOwner = this.eap$lastOwner == null && owner == null || this.eap$lastOwner != null && this.eap$lastOwner.equals(owner);
            if (this.eap$link != null && this.eap$lastChannel == channel && sameOwner) {
                return;
            }
            this.eap$lastChannel = channel;
            if (!found) {
                if (this.eap$link != null) {
                    this.eap$link.setPlacerId(null);
                    this.eap$link.setFrequency(0L);
                    this.eap$link.updateStatus();
                    ((AEBasePart)this).getHost().markForUpdate();
                }
                this.eap$lastChannel = 0L;
                this.eap$lastOwner = null;
                return;
            }
            if (this.eap$link == null) {
                GenericNodeEndpointImpl endpoint = new GenericNodeEndpointImpl(() -> ((AEBasePart)this).getHost().getBlockEntity(), () -> ((IActionHost)this).getActionableNode());
                this.eap$link = new WirelessSlaveLink(endpoint);
            }
            this.eap$link.setPlacerId(owner);
            this.eap$link.setFrequency(channel);
            this.eap$link.updateStatus();
            this.eap$lastOwner = owner;
            ((AEBasePart)this).getHost().markForUpdate();
        }
        catch (Exception e) {
            ExtendedAELogger.LOGGER.error("[\u670d\u52a1\u7aef] StorageBus \u521d\u59cb\u5316\u9891\u9053\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    @Unique
    private UUID eap$getFallbackOwner() {
        try {
            IGridNode node = ((IActionHost)this).getActionableNode();
            if (node != null) {
                return node.getOwningPlayerProfileId();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

