/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.extendedae.container;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.PatternProviderMenu;
import appeng.menu.slot.AppEngSlot;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={ContainerExPatternProvider.class}, priority=3000, remap=false)
public abstract class ContainerExPatternProviderMixin
extends PatternProviderMenu {
    @GuiSync(value=31415)
    @Unique
    public int eap$page = 0;
    @Unique
    public int eap$maxPage = 0;
    @Unique
    private static final int SLOTS_PER_PAGE = 36;

    public ContainerExPatternProviderMixin(MenuType<? extends PatternProviderMenu> menuType, int id, Inventory playerInventory, PatternProviderLogicHost host) {
        super(menuType, id, playerInventory, host);
    }

    @Unique
    public void eap$showPage() {
        List slots = this.getSlots(SlotSemantics.ENCODED_PATTERN);
        int totalSlots = slots.size();
        if (totalSlots <= 36) {
            for (Slot s : slots) {
                ((AppEngSlot)s).setActive(true);
            }
            return;
        }
        int slot_id = 0;
        for (Slot s : slots) {
            int page_id = slot_id / 36;
            ((AppEngSlot)s).setActive(page_id == this.eap$page);
            ++slot_id;
        }
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/patternprovider/PatternProviderLogicHost;)V"}, at={@At(value="TAIL")}, remap=false, require=0)
    private void eap$initPages(int id, Inventory playerInventory, PatternProviderLogicHost host, CallbackInfo ci) {
        int maxSlots = this.getSlots(SlotSemantics.ENCODED_PATTERN).size();
        this.eap$maxPage = (maxSlots + 36 - 1) / 36;
    }

    @Unique
    public int getPage() {
        return this.eap$page;
    }

    @Unique
    public void setPage(int page) {
        this.eap$page = page;
    }

    @Unique
    private void eap$modifyPatterns(int scale, boolean div) {
        if (scale <= 0) {
            return;
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            ItemStack stack = slot.getItem();
            Item item = stack.getItem();
            if (!(item instanceof EncodedPatternItem)) continue;
            EncodedPatternItem pattern = (EncodedPatternItem)item;
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
            if (!(detail instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            List input = process.getSparseInputs();
            List output = process.getOutputs();
            if (!this.eap$checkModify(input, scale, div) || !this.eap$checkModify(output, scale, div)) continue;
            List<GenericStack> mulInput = this.eap$modifyStacks(input, scale, div);
            List<GenericStack> mulOutput = this.eap$modifyStacks(output, scale, div);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern(mulInput, mulOutput);
            slot.set(newPattern);
        }
    }

    @Unique
    private boolean eap$checkModify(List<GenericStack> stacks, int scale, boolean div) {
        if (stacks == null) {
            return false;
        }
        if (div) {
            for (GenericStack stack : stacks) {
                if (stack == null || stack.amount() % (long)scale == 0L) continue;
                return false;
            }
            return true;
        }
        for (GenericStack stack : stacks) {
            if (stack == null) continue;
            long upper = 999999L * (long)stack.what().getAmountPerUnit();
            if (stack.amount() * (long)scale <= upper) continue;
            return false;
        }
        return true;
    }

    @Unique
    private List<GenericStack> eap$modifyStacks(List<GenericStack> src, int scale, boolean div) {
        ArrayList<GenericStack> dst = new ArrayList<GenericStack>(src.size());
        for (GenericStack stack : src) {
            if (stack != null) {
                long amt = stack.amount();
                long newAmt = div ? amt / (long)scale : amt * (long)scale;
                dst.add(new GenericStack(stack.what(), newAmt));
                continue;
            }
            dst.add(null);
        }
        return dst;
    }
}

