/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.client.ClientAdvancedBlockingState;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class AdvancedBlockingSyncS2CPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<AdvancedBlockingSyncS2CPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"adv_blocking_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AdvancedBlockingSyncS2CPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeUtf(pkt.dimensionId);
        buf.writeLong(pkt.blockPosLong);
        buf.writeBoolean(pkt.enabled);
    }, buf -> new AdvancedBlockingSyncS2CPacket(buf.readUtf(), buf.readLong(), buf.readBoolean()));
    private final String dimensionId;
    private final long blockPosLong;
    private final boolean enabled;

    public AdvancedBlockingSyncS2CPacket(String dimensionId, long blockPosLong, boolean enabled) {
        this.dimensionId = dimensionId;
        this.blockPosLong = blockPosLong;
        this.enabled = enabled;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(AdvancedBlockingSyncS2CPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            String key = ClientAdvancedBlockingState.key(msg.dimensionId, msg.blockPosLong);
            ClientAdvancedBlockingState.set(key, msg.enabled);
        });
    }
}

