/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.service.CraftingService;
import appeng.menu.me.crafting.CraftingCPUMenu;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CraftingMonitorJumpC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<CraftingMonitorJumpC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"crafting_monitor_jump"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingMonitorJumpC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> AEKey.writeKey((RegistryFriendlyByteBuf)buf, (AEKey)pkt.what), buf -> new CraftingMonitorJumpC2SPacket(AEKey.readKey((RegistryFriendlyByteBuf)buf)));
    private final AEKey what;

    public CraftingMonitorJumpC2SPacket(AEKey what) {
        this.what = what;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CraftingMonitorJumpC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            IActionHost host;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (!(patt1$temp instanceof CraftingCPUMenu)) {
                return;
            }
            CraftingCPUMenu menu = (CraftingCPUMenu)patt1$temp;
            IGrid grid = null;
            Object target = menu.getTarget();
            if (target instanceof IActionHost && (host = (IActionHost)target).getActionableNode() != null) {
                grid = host.getActionableNode().getGrid();
            }
            if (grid == null) {
                return;
            }
            ICraftingService cs = grid.getCraftingService();
            if (!(cs instanceof CraftingService)) {
                return;
            }
            CraftingService craftingService = (CraftingService)cs;
            Collection patterns = craftingService.getCraftingFor(msg.what);
            if (patterns.isEmpty()) {
                return;
            }
            for (IPatternDetails pattern : patterns) {
                Iterable providers = craftingService.getProviders(pattern);
                int providerCount = 0;
                for (ICraftingProvider provider : providers) {
                    PatternProviderLogic ppl;
                    PatternProviderLogicHost host2;
                    ++providerCount;
                    if (!(provider instanceof PatternProviderLogic) || (host2 = ((PatternProviderLogicAccessor)(ppl = (PatternProviderLogic)provider)).eap$host()) == null) continue;
                    BlockEntity pbe = host2.getBlockEntity();
                    ServerLevel serverLevel = player.serverLevel();
                    for (Direction dir : host2.getTargets()) {
                        BlockPos targetPos = pbe.getBlockPos().relative(dir);
                        BlockEntity tbe = serverLevel.getBlockEntity(targetPos);
                        if (tbe instanceof MenuProvider) {
                            MenuProvider provider1 = (MenuProvider)tbe;
                            player.openMenu(provider1, targetPos);
                            return;
                        }
                        BlockState tstate = serverLevel.getBlockState(targetPos);
                        MenuProvider provider2 = tstate.getMenuProvider((Level)serverLevel, targetPos);
                        if (provider2 == null) continue;
                        player.openMenu(provider2, targetPos);
                        return;
                    }
                }
            }
        });
    }
}

