/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.util.IConfigManager;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.parts.crafting.PatternProviderPart;
import com.extendedae_plus.api.advancedBlocking.IAdvancedBlocking;
import com.extendedae_plus.api.smartDoubling.ISmartDoubling;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class GlobalToggleProviderModesC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<GlobalToggleProviderModesC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"global_toggle_provider_modes"));
    public static final StreamCodec<FriendlyByteBuf, GlobalToggleProviderModesC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeByte(pkt.opBlocking.id);
        buf.writeByte(pkt.opAdvancedBlocking.id);
        buf.writeByte(pkt.opSmartDoubling.id);
        buf.writeBlockPos(pkt.controllerPos);
    }, buf -> new GlobalToggleProviderModesC2SPacket(Op.byId(buf.readByte()), Op.byId(buf.readByte()), Op.byId(buf.readByte()), buf.readBlockPos()));
    private final Op opBlocking;
    private final Op opAdvancedBlocking;
    private final Op opSmartDoubling;
    private final BlockPos controllerPos;

    public GlobalToggleProviderModesC2SPacket(Op opBlocking, Op opAdvancedBlocking, Op opSmartDoubling, BlockPos controllerPos) {
        this.opBlocking = opBlocking;
        this.opAdvancedBlocking = opAdvancedBlocking;
        this.opSmartDoubling = opSmartDoubling;
        this.controllerPos = controllerPos;
    }

    public static void handle(GlobalToggleProviderModesC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.controllerPos);
            if (!(be instanceof IInWorldGridNodeHost)) {
                return;
            }
            IInWorldGridNodeHost host = (IInWorldGridNodeHost)be;
            IGridNode node = host.getGridNode(null);
            if (node == null) {
                return;
            }
            IGrid grid = node.getGrid();
            if (grid == null) {
                return;
            }
            int affected = GlobalToggleProviderModesC2SPacket.applyToAllProviders(grid, msg);
            player.displayClientMessage((Component)Component.literal((String)("E+ \u5168\u5c40\u5207\u6362\u5df2\u5e94\u7528\u5230 " + affected + " \u4e2a\u6837\u677f\u4f9b\u5e94\u5668")), true);
        });
    }

    private static int applyToAllProviders(IGrid grid, GlobalToggleProviderModesC2SPacket msg) {
        int affected = 0;
        HashSet<PatternProviderLogic> all = new HashSet<PatternProviderLogic>();
        try {
            Set blocksAll = grid.getMachines(PatternProviderBlockEntity.class);
            Set blocksActive = grid.getActiveMachines(PatternProviderBlockEntity.class);
            for (PatternProviderBlockEntity be : blocksAll) {
                if (be == null || be.getLogic() == null) continue;
                all.add(be.getLogic());
            }
            for (PatternProviderBlockEntity be : blocksActive) {
                if (be == null || be.getLogic() == null) continue;
                all.add(be.getLogic());
            }
        }
        catch (Throwable blocksAll) {
            // empty catch block
        }
        try {
            Set partsAll = grid.getMachines(PatternProviderPart.class);
            Set partsActive = grid.getActiveMachines(PatternProviderPart.class);
            for (PatternProviderPart part : partsAll) {
                if (part == null || part.getLogic() == null) continue;
                all.add(part.getLogic());
            }
            for (PatternProviderPart part : partsActive) {
                if (part == null || part.getLogic() == null) continue;
                all.add(part.getLogic());
            }
        }
        catch (Throwable partsAll) {
            // empty catch block
        }
        try {
            Set hostsAll = grid.getMachines(PatternProviderLogicHost.class);
            Set hostsActive = grid.getActiveMachines(PatternProviderLogicHost.class);
            for (PatternProviderLogicHost host : hostsAll) {
                if (host == null || host.getLogic() == null) continue;
                all.add(host.getLogic());
            }
            for (PatternProviderLogicHost host : hostsActive) {
                if (host == null || host.getLogic() == null) continue;
                all.add(host.getLogic());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GlobalToggleProviderModesC2SPacket.collectByClassName(grid, all, "com.glodblock.github.extendedae.common.parts.PartExPatternProvider");
        GlobalToggleProviderModesC2SPacket.collectByClassName(grid, all, "com.glodblock.github.extendedae.common.tileentities.TileExPatternProvider");
        for (PatternProviderLogic logic : all) {
            if (!GlobalToggleProviderModesC2SPacket.applyToLogic(logic, msg)) continue;
            ++affected;
        }
        return affected;
    }

    private static void collectByClassName(IGrid grid, Set<PatternProviderLogic> out, String className) {
        try {
            Class<?> cls = Class.forName(className);
            Set all = grid.getMachines(cls);
            Set active = grid.getActiveMachines(cls);
            for (Object o : all) {
                GlobalToggleProviderModesC2SPacket.addLogicIfPresent(out, o);
            }
            for (Object o : active) {
                GlobalToggleProviderModesC2SPacket.addLogicIfPresent(out, o);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void addLogicIfPresent(Set<PatternProviderLogic> out, Object o) {
        try {
            if (o instanceof PatternProviderLogicHost) {
                PatternProviderLogicHost host = (PatternProviderLogicHost)o;
                PatternProviderLogic logic = host.getLogic();
                if (logic != null) {
                    out.add(logic);
                }
                return;
            }
            Method m = o.getClass().getMethod("getLogic", new Class[0]);
            Object ret = m.invoke(o, new Object[0]);
            if (ret instanceof PatternProviderLogic) {
                PatternProviderLogic logic = (PatternProviderLogic)ret;
                out.add(logic);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean applyToLogic(PatternProviderLogic logic, GlobalToggleProviderModesC2SPacket msg) {
        boolean current;
        if (logic == null) {
            return false;
        }
        boolean changed = false;
        if (msg.opBlocking != Op.NOOP) {
            boolean current2 = GlobalToggleProviderModesC2SPacket.safeIsBlocking(logic);
            boolean target = GlobalToggleProviderModesC2SPacket.computeTarget(current2, msg.opBlocking);
            IConfigManager cm = logic.getConfigManager();
            if (cm != null) {
                cm.putSetting(Settings.BLOCKING_MODE, (Enum)(target ? YesNo.YES : YesNo.NO));
                boolean bl = changed = changed || current2 != target;
            }
        }
        if (msg.opAdvancedBlocking != Op.NOOP && logic instanceof IAdvancedBlocking) {
            IAdvancedBlocking adv = (IAdvancedBlocking)logic;
            current = adv.eap$getAdvancedBlocking();
            boolean target = GlobalToggleProviderModesC2SPacket.computeTarget(current, msg.opAdvancedBlocking);
            adv.eap$setAdvancedBlocking(target);
            boolean bl = changed = changed || current != target;
        }
        if (msg.opSmartDoubling != Op.NOOP && logic instanceof ISmartDoubling) {
            ISmartDoubling sd = (ISmartDoubling)logic;
            current = sd.eap$getSmartDoubling();
            boolean target = GlobalToggleProviderModesC2SPacket.computeTarget(current, msg.opSmartDoubling);
            sd.eap$setSmartDoubling(target);
            boolean bl = changed = changed || current != target;
        }
        if (changed) {
            try {
                logic.saveChanges();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return changed;
    }

    private static boolean computeTarget(boolean current, Op op) {
        return switch (op.ordinal()) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> {
                if (!current) {
                    yield true;
                }
                yield false;
            }
            default -> current;
        };
    }

    private static boolean safeIsBlocking(PatternProviderLogic logic) {
        try {
            return logic.isBlocking();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Op {
        NOOP(0),
        SET_TRUE(1),
        SET_FALSE(2),
        TOGGLE(3);

        public final byte id;

        private Op(byte id) {
            this.id = id;
        }

        static Op byId(byte id) {
            return switch (id) {
                case 1 -> SET_TRUE;
                case 2 -> SET_FALSE;
                case 3 -> TOGGLE;
                default -> NOOP;
            };
        }
    }
}

