/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.stacks.GenericStack;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import appeng.menu.implementations.InterfaceMenu;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class InterfaceAdjustConfigAmountC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<InterfaceAdjustConfigAmountC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"interface_adjust_config_amount"));
    public static final StreamCodec<FriendlyByteBuf, InterfaceAdjustConfigAmountC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeVarInt(pkt.slotIndex);
        buf.writeBoolean(pkt.divide);
        buf.writeVarInt(pkt.factor);
    }, buf -> new InterfaceAdjustConfigAmountC2SPacket(buf.readVarInt(), buf.readBoolean(), buf.readVarInt()));
    private final int slotIndex;
    private final boolean divide;
    private final int factor;

    public InterfaceAdjustConfigAmountC2SPacket(int slotIndex, boolean divide, int factor) {
        this.slotIndex = slotIndex;
        this.divide = divide;
        this.factor = factor;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(InterfaceAdjustConfigAmountC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            InterfaceMenu menu = null;
            ContainerExInterface exMenu = null;
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (patt1$temp instanceof InterfaceMenu) {
                InterfaceMenu im;
                menu = im = (InterfaceMenu)patt1$temp;
            } else {
                AbstractContainerMenu patt2$temp = player.containerMenu;
                if (patt2$temp instanceof ContainerExInterface) {
                    ContainerExInterface cem;
                    exMenu = cem = (ContainerExInterface)patt2$temp;
                } else {
                    return;
                }
            }
            try {
                InterfaceLogic logic = (menu != null ? (InterfaceLogicHost)menu.getHost() : (InterfaceLogicHost)exMenu.getHost()).getInterfaceLogic();
                ConfigInventory config = logic.getConfig();
                if (msg.slotIndex == -1) {
                    int size = config.size();
                    for (int idx = 0; idx < size; ++idx) {
                        long next;
                        GenericStack st = config.getStack(idx);
                        if (st == null) continue;
                        long current = st.amount();
                        int factor = Math.max(1, msg.factor);
                        if (msg.divide) {
                            if (factor <= 1 || current % (long)factor != 0L) continue;
                            next = current / (long)factor;
                            if (next < 1L) {
                                next = 1L;
                            }
                        } else {
                            if (factor <= 1) continue;
                            next = current * (long)factor;
                            if (next < 1L) {
                                next = 1L;
                            }
                        }
                        GenericStack newStack = new GenericStack(st.what(), next);
                        config.setStack(idx, newStack);
                    }
                } else {
                    long next;
                    GenericStack stack = config.getStack(msg.slotIndex);
                    if (stack == null) {
                        return;
                    }
                    long current = stack.amount();
                    int factor = Math.max(1, msg.factor);
                    if (msg.divide) {
                        if (factor <= 1) {
                            return;
                        }
                        if (current % (long)factor != 0L) {
                            return;
                        }
                        next = current / (long)factor;
                        if (next < 1L) {
                            next = 1L;
                        }
                    } else {
                        if (factor <= 1) {
                            return;
                        }
                        next = current * (long)factor;
                        if (next < 1L) {
                            next = 1L;
                        }
                    }
                    GenericStack newStack = new GenericStack(stack.what(), next);
                    config.setStack(msg.slotIndex, newStack);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

