/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.client.screen.ProviderSelectScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ProvidersListS2CPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ProvidersListS2CPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"providers_list"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProvidersListS2CPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeVarInt(pkt.ids.size());
        for (int i = 0; i < pkt.ids.size(); ++i) {
            buf.writeLong(pkt.ids.get(i).longValue());
            buf.writeUtf(pkt.names.get(i));
            buf.writeVarInt(pkt.emptySlots.get(i).intValue());
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<Long> ids = new ArrayList<Long>(size);
        ArrayList<String> names = new ArrayList<String>(size);
        ArrayList<Integer> slots = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            ids.add(buf.readLong());
            names.add(buf.readUtf());
            slots.add(buf.readVarInt());
        }
        return new ProvidersListS2CPacket(ids, names, slots);
    });
    private final List<Long> ids;
    private final List<String> names;
    private final List<Integer> emptySlots;

    ProvidersListS2CPacket(List<Long> ids, List<String> names, List<Integer> emptySlots) {
        this.ids = ids;
        this.names = names;
        this.emptySlots = emptySlots;
    }

    public static void handle(ProvidersListS2CPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> ProvidersListS2CPacket.handleClient(msg));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(ProvidersListS2CPacket msg) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        Screen current = mc.screen;
        mc.setScreen((Screen)new ProviderSelectScreen(current, msg.ids, msg.names, msg.emptySlots));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

