/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import com.extendedae_plus.network.ProvidersListS2CPacket;
import com.extendedae_plus.util.uploadPattern.ExtendedAEPatternUploadUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RequestProvidersListC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RequestProvidersListC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"request_providers_list"));
    public static final RequestProvidersListC2SPacket INSTANCE = new RequestProvidersListC2SPacket();
    public static final StreamCodec<FriendlyByteBuf, RequestProvidersListC2SPacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private RequestProvidersListC2SPacket() {
    }

    public static void handle(RequestProvidersListC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (!(patt1$temp instanceof PatternEncodingTermMenu)) {
                return;
            }
            PatternEncodingTermMenu encMenu = (PatternEncodingTermMenu)patt1$temp;
            PatternAccessTermMenu accessMenu = ExtendedAEPatternUploadUtil.getPatternAccessMenu(player);
            if (accessMenu != null) {
                List<Long> ids = ExtendedAEPatternUploadUtil.getAllProviderIds(accessMenu);
                ArrayList<Long> filteredIds = new ArrayList<Long>();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (Long id : ids) {
                    int empty;
                    if (id == null || !ExtendedAEPatternUploadUtil.isProviderAvailable(id, accessMenu) || (empty = ExtendedAEPatternUploadUtil.getAvailableSlots(id, accessMenu)) <= 0) continue;
                    filteredIds.add(id);
                    names.add(ExtendedAEPatternUploadUtil.getProviderDisplayName(id, accessMenu));
                    slots.add(empty);
                }
                player.connection.send((CustomPacketPayload)new ProvidersListS2CPacket(filteredIds, names, slots));
                return;
            }
            List<PatternContainer> containers = ExtendedAEPatternUploadUtil.listAvailableProvidersFromGrid(encMenu);
            ArrayList<Long> idxIds = new ArrayList<Long>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < containers.size(); ++i) {
                int empty;
                PatternContainer c = containers.get(i);
                if (c == null || (empty = ExtendedAEPatternUploadUtil.getAvailableSlots(c)) <= 0) continue;
                long encodedId = -1L - (long)i;
                idxIds.add(encodedId);
                names.add(ExtendedAEPatternUploadUtil.getProviderDisplayName(c));
                slots.add(empty);
            }
            player.connection.send((CustomPacketPayload)new ProvidersListS2CPacket(idxIds, names, slots));
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

