/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.stacks.AEKey;
import com.extendedae_plus.content.ClientPatternHighlightStore;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SetPatternHighlightS2CPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SetPatternHighlightS2CPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"set_pattern_highlight"));
    private final AEKey key;
    private final boolean highlight;
    public static final StreamCodec<RegistryFriendlyByteBuf, SetPatternHighlightS2CPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        AEKey.writeKey((RegistryFriendlyByteBuf)buf, (AEKey)pkt.key);
        buf.writeBoolean(pkt.highlight);
    }, buf -> new SetPatternHighlightS2CPacket(AEKey.readKey((RegistryFriendlyByteBuf)buf), buf.readBoolean()));

    public SetPatternHighlightS2CPacket(AEKey key, boolean highlight) {
        this.key = key;
        this.highlight = highlight;
    }

    public AEKey key() {
        return this.key;
    }

    public boolean highlight() {
        return this.highlight;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetPatternHighlightS2CPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            try {
                ClientPatternHighlightStore.setHighlight(msg.key, msg.highlight);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

