/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.ExtendedAEPlus;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SetWirelessFrequencyC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SetWirelessFrequencyC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"set_wireless_frequency"));
    public static final StreamCodec<FriendlyByteBuf, SetWirelessFrequencyC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeBlockPos(pkt.pos);
        buf.writeLong(pkt.frequency);
    }, buf -> new SetWirelessFrequencyC2SPacket(buf.readBlockPos(), buf.readLong()));
    private final BlockPos pos;
    private final long frequency;

    public SetWirelessFrequencyC2SPacket(BlockPos pos, long frequency) {
        this.pos = pos;
        this.frequency = frequency;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetWirelessFrequencyC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (player.distanceToSqr((double)msg.pos.getX() + 0.5, (double)msg.pos.getY() + 0.5, (double)msg.pos.getZ() + 0.5) > 64.0) {
                ExtendedAEPlus.LOGGER.warn("Player {} tried to set frequency from too far away", (Object)player.getName().getString());
                return;
            }
            BlockEntity be = player.level().getBlockEntity(msg.pos);
            if (!(be instanceof WirelessTransceiverBlockEntity)) {
                ExtendedAEPlus.LOGGER.warn("Invalid block entity at {} for frequency setting", (Object)msg.pos);
                return;
            }
            WirelessTransceiverBlockEntity transceiver = (WirelessTransceiverBlockEntity)be;
            transceiver.setFrequencyForced(msg.frequency);
            ExtendedAEPlus.LOGGER.debug("Set transceiver frequency at {} to {} (forced)", (Object)msg.pos, (Object)msg.frequency);
        });
    }
}

