/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.util.uploadPattern.ExtendedAEPatternUploadUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UploadInventoryPatternToProviderC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<UploadInventoryPatternToProviderC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"upload_inventory_pattern_to_provider"));
    public static final StreamCodec<FriendlyByteBuf, UploadInventoryPatternToProviderC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeVarInt(pkt.playerSlotIndex);
        buf.writeLong(pkt.providerId);
    }, buf -> new UploadInventoryPatternToProviderC2SPacket(buf.readVarInt(), buf.readLong()));
    private final int playerSlotIndex;
    private final long providerId;

    public UploadInventoryPatternToProviderC2SPacket(int playerSlotIndex, long providerId) {
        this.playerSlotIndex = playerSlotIndex;
        this.providerId = providerId;
    }

    public static void handle(UploadInventoryPatternToProviderC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ExtendedAEPatternUploadUtil.uploadPatternToProvider(player, msg.playerSlotIndex, msg.providerId);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

