/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.storage;

import java.math.BigInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class InfinityDataStorage {
    public static final InfinityDataStorage EMPTY = new InfinityDataStorage();
    public ListTag keys;
    public ListTag amounts;
    public BigInteger itemCount;

    public InfinityDataStorage() {
        this(new ListTag(), new ListTag(), BigInteger.ZERO);
    }

    private InfinityDataStorage(ListTag keys, ListTag amounts, BigInteger itemCount) {
        this.keys = keys;
        this.amounts = amounts;
        this.itemCount = itemCount;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("infinity_cell_keys", (Tag)this.keys);
        nbt.put("infinity_cell_amounts", (Tag)this.amounts);
        nbt.putByteArray("infinity_cell_item_count", this.itemCount.toByteArray());
        return nbt;
    }

    public static InfinityDataStorage loadFromNBT(CompoundTag nbt) {
        ListTag keys = nbt.getList("infinity_cell_keys", 10);
        ListTag amounts = nbt.getList("infinity_cell_amounts", 10);
        BigInteger itemCount = new BigInteger(nbt.getByteArray("infinity_cell_item_count"));
        return new InfinityDataStorage(keys, amounts, itemCount);
    }
}

